/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.DefaultHttpBinding;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpPollingConsumer;
import org.apache.camel.component.http.HttpProducer;
import org.apache.camel.component.http.UrlRewrite;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="http,https", title="HTTP,HTTPS", syntax="http:httpUri", producerOnly=true, label="http")
public class HttpEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    private HttpComponent component;
    private HttpClientParams clientParams;
    private HttpClientConfigurer httpClientConfigurer;
    private HttpConnectionManager httpConnectionManager;
    private UrlRewrite urlRewrite;
    @UriPath(label="producer", description="The url of the HTTP endpoint to call.")
    @Metadata(required="true")
    private URI httpUri;
    @UriParam(description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    @UriParam(description="To use a custom HttpBinding to control the mapping between Camel message and HttpClient.")
    private HttpBinding binding;
    @UriParam(label="producer", defaultValue="true", description="Option to disable throwing the HttpOperationFailedException in case of failed responses from the remote server. This allows you to get all responses regardless of the HTTP status code.")
    private boolean throwExceptionOnFailure = true;
    @UriParam(label="producer", description="If the option is true, HttpProducer will ignore the Exchange.HTTP_URI header, and use the endpoint's URI for request. You may also set the option throwExceptionOnFailure to be false to let the HttpProducer send all the fault response back.")
    private boolean bridgeEndpoint;
    @UriParam(label="consumer", description="Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.")
    private boolean matchOnUriPrefix;
    @UriParam(defaultValue="true", description="If this option is false Jetty servlet will disable the HTTP streaming and set the content-length header on the response")
    private boolean chunked = true;
    @UriParam(label="consumer", description="Determines whether or not the raw input stream from Jetty is cached or not (Camel will read the stream into a in memory/overflow to file, Stream caching) cache. By default Camel will cache the Jetty input stream to support reading it multiple times to ensure it Camel can retrieve all data from the stream. However you can set this option to true when you for example need to access the raw stream, such as streaming it directly to a file or other persistent store. DefaultHttpBinding will copy the request input stream into a stream cache and put it into message body if this option is false to support reading the stream multiple times. If you use Jetty to bridge/proxy an endpoint then consider enabling this option to improve performance, in case you do not need to read the message payload multiple times.")
    private boolean disableStreamCache;
    @UriParam(label="producer", description="The proxy host name")
    private String proxyHost;
    @UriParam(label="producer", description="The proxy port number")
    private int proxyPort;
    @UriParam(label="producer", enums="Basic,Digest,NTLM", description="Authentication method for proxy, either as Basic, Digest or NTLM.")
    private String authMethodPriority;
    @UriParam(description="Option to disable throwing the HttpOperationFailedException in case of failed responses from the remote server. This allows you to get all responses regardless of the HTTP status code.")
    private boolean transferException;
    @UriParam(label="consumer", description="Specifies whether to enable HTTP TRACE for this Jetty consumer. By default TRACE is turned off.")
    private boolean traceEnabled;
    @UriParam(label="consumer", description="Used to only allow consuming if the HttpMethod matches, such as GET/POST/PUT etc. Multiple methods can be specified separated by comma.")
    private String httpMethodRestrict;
    @UriParam(label="consumer", description="To use a custom buffer size on the javax.servlet.ServletResponse.")
    private Integer responseBufferSize;
    @UriParam(label="producer", description="If this option is true, The http producer won't read response body and cache the input stream")
    private boolean ignoreResponseBody;

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpConnectionManager httpConnectionManager) throws URISyntaxException {
        this(endPointURI, component, httpURI, new HttpClientParams(), httpConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientParams clientParams, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        this(endPointURI, component, null, clientParams, httpConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientParams clientParams, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (Component)component);
        this.component = component;
        this.httpUri = httpURI;
        this.clientParams = clientParams;
        this.httpClientConfigurer = clientConfigurer;
        this.httpConnectionManager = httpConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from http endpoint");
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public HttpClient createHttpClient() {
        ObjectHelper.notNull((Object)this.clientParams, (String)"clientParams");
        ObjectHelper.notNull((Object)this.httpConnectionManager, (String)"httpConnectionManager");
        HttpClient answer = new HttpClient(this.getClientParams());
        if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyPort"))) {
            String host = this.getCamelContext().getProperty("http.proxyHost");
            int port = Integer.parseInt(this.getCamelContext().getProperty("http.proxyPort"));
            LOG.debug("CamelContext properties http.proxyHost and http.proxyPort detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            answer.getHostConfiguration().setProxy(host, port);
        }
        if (this.proxyHost != null) {
            LOG.debug("Using proxy: {}:{}", (Object)this.proxyHost, (Object)this.proxyPort);
            answer.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
        }
        if (this.authMethodPriority != null) {
            ArrayList<String> authPrefs = new ArrayList<String>();
            Iterator it = (Iterator)this.getCamelContext().getTypeConverter().convertTo(Iterator.class, (Object)this.authMethodPriority);
            int i = 1;
            while (it.hasNext()) {
                Object value = it.next();
                AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, value));
                if (auth == null) {
                    throw new IllegalArgumentException("Unknown authMethod: " + value + " in authMethodPriority: " + this.authMethodPriority);
                }
                LOG.debug("Using authSchemePriority #{}: {}", (Object)i, (Object)auth);
                authPrefs.add(auth.name());
                ++i;
            }
            if (!authPrefs.isEmpty()) {
                answer.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            }
        }
        answer.setHttpConnectionManager(this.httpConnectionManager);
        HttpClientConfigurer configurer = this.getHttpClientConfigurer();
        if (configurer != null) {
            configurer.configureHttpClient(answer);
        }
        return answer;
    }

    public void connect(HttpConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultHttpBinding();
            this.binding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.binding.setTransferException(this.isTransferException());
        }
        return this.binding;
    }

    public void setBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public String getPath() {
        return this.httpUri.getPath().length() == 0 ? "/" : this.httpUri.getPath();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridge) {
        this.bridgeEndpoint = bridge;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean match) {
        this.matchOnUriPrefix = match;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disable) {
        this.disableStreamCache = disable;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getAuthMethodPriority() {
        return this.authMethodPriority;
    }

    public void setAuthMethodPriority(String authMethodPriority) {
        this.authMethodPriority = authMethodPriority;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public UrlRewrite getUrlRewrite() {
        return this.urlRewrite;
    }

    public void setUrlRewrite(UrlRewrite urlRewrite) {
        this.urlRewrite = urlRewrite;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public boolean isIgnoreResponseBody() {
        return this.ignoreResponseBody;
    }

    public void setIgnoreResponseBody(boolean ignoreResponseBody) {
        this.ignoreResponseBody = ignoreResponseBody;
    }
}

