/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final boolean proxy;
    private final String username;
    private final String password;

    public BasicAuthenticationHttpClientConfigurer(boolean proxy, String user, String pwd) {
        this.proxy = proxy;
        this.username = user;
        this.password = pwd;
    }

    public void configureHttpClient(HttpClient client) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        if (this.proxy) {
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
        } else {
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

