/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.component.http.helper.HttpProducerHelper;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(HttpProducer.class);
    private HttpClient httpClient;
    private boolean throwException;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
        this.throwException = endpoint.isThrowExceptionOnFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block9: {
            if (this.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            }
            HttpMethod method = this.createMethod(exchange);
            Message in = exchange.getIn();
            HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
            for (Map.Entry entry : in.getHeaders().entrySet()) {
                String headerValue = (String)in.getHeader((String)entry.getKey(), String.class);
                if (strategy == null || strategy.applyFilterToCamelHeaders((String)entry.getKey(), (Object)headerValue, exchange)) continue;
                method.addRequestHeader((String)entry.getKey(), headerValue);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing http " + method.getName() + " method: " + method.getURI().toString()));
                }
                int responseCode = this.executeMethod(method);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Http responseCode: " + responseCode));
                }
                if (!this.throwException) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block9;
                }
                if (responseCode >= 100 && responseCode < 300) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block9;
                }
                throw this.populateHttpOperationFailedException(exchange, method, responseCode);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpMethod method, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Header[] headers;
        Message answer = exchange.getOut();
        answer.setHeaders(in.getHeaders());
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        answer.setBody((Object)HttpProducer.extractResponseBody(method, exchange));
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            answer.setHeader(name, (Object)value);
        }
    }

    protected HttpOperationFailedException populateHttpOperationFailedException(Exchange exchange, HttpMethod method, int responseCode) throws IOException {
        HttpOperationFailedException exception;
        String uri = method.getURI().toString();
        String statusText = method.getStatusLine() != null ? method.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(method.getResponseHeaders());
        InputStream is = HttpProducer.extractResponseBody(method, exchange);
        String copy = null;
        if (is != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)is);
        }
        if (responseCode >= 300 && responseCode < 400) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                exception = new HttpOperationFailedException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        return this.httpClient.executeMethod(method);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected static InputStream extractResponseBody(HttpMethod method, Exchange exchange) throws IOException {
        String contentType;
        int index;
        String contentEncoding;
        InputStream is = method.getResponseBodyAsStream();
        if (is == null) {
            return null;
        }
        Header header = method.getRequestHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip(contentEncoding, is);
        }
        if ((header = method.getResponseHeader("content-type")) != null && (index = (contentType = header.getValue()).indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)charset);
        }
        return HttpProducer.doExtractResponseBody(is, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream doExtractResponseBody(InputStream is, Exchange exchange) throws IOException {
        try {
            CachedOutputStream cos = new CachedOutputStream(exchange);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getInputStream();
            return inputStream;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
        }
    }

    protected HttpMethod createMethod(Exchange exchange) throws InvalidPayloadException {
        String url = HttpProducerHelper.createURL(exchange, this.getEndpoint());
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods methodToUse = HttpProducerHelper.createMethod(exchange, this.getEndpoint(), requestEntity != null);
        HttpMethod method = methodToUse.createMethod(url);
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = this.getEndpoint().getHttpUri().getRawQuery();
        }
        if (queryString != null) {
            method.setQueryString(queryString);
        }
        if (methodToUse.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("No Content-Type provided for URL: " + url + " with exchange: " + exchange));
            }
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) throws InvalidPayloadException {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        RequestEntity answer = (RequestEntity)in.getBody(RequestEntity.class);
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    String contentType = ExchangeHelper.getContentType((Exchange)exchange);
                    if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            answer = new FileRequestEntity(file, contentType);
                        }
                    } else if (data instanceof String) {
                        String charset = IOConverter.getCharsetName((Exchange)exchange, (boolean)false);
                        answer = new StringRequestEntity((String)data, contentType, charset);
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        answer = new InputStreamRequestEntity(is, contentType);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

