/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class HttpConsumer
extends DefaultConsumer {
    private final HttpEndpoint endpoint;
    private boolean traceEnabled;

    public HttpConsumer(HttpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        if (endpoint.isTraceEnabled()) {
            this.setTraceEnabled(true);
        }
        this.endpoint = endpoint;
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    public HttpBinding getBinding() {
        return this.endpoint.getBinding();
    }

    public String getPath() {
        return this.endpoint.getPath();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.disconnect(this);
        super.doStop();
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }
}

