/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4.helper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.http4.HttpConverter;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMessage;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.camel.component.http4.HttpServletUrlRewrite;
import org.apache.camel.component.http4.helper.UrlRewriteHttpServletRequestAdapter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHelper.class);

    private HttpHelper() {
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)charset));
        }
    }

    public static void writeObjectToServletResponse(ServletResponse response, Object target) throws IOException {
        response.setContentType("application/x-java-serialized-object");
        HttpHelper.writeObjectToStream((OutputStream)response.getOutputStream(), target);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static Object readResponseBodyFromServletRequest(HttpServletRequest request, Exchange exchange) throws IOException {
        InputStream is = HttpConverter.toInputStream(request, exchange);
        return HttpHelper.readResponseBodyFromInputStream(is, exchange);
    }

    public static Object readResponseBodyFromInputStream(InputStream is, Exchange exchange) throws IOException {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
        return cos.getStreamCache();
    }

    public static String createURL(Exchange exchange, HttpEndpoint endpoint) {
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encode((String)uri);
        return uri;
    }

    public static URI createURI(Exchange exchange, String url, HttpEndpoint endpoint) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        if (queryString == null) {
            queryString = uri.getQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encode((String)queryString);
            uri = URISupport.createURIWithQuery((URI)uri, (String)queryString);
        }
        return uri;
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) throws URISyntaxException {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        String uriString = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        try {
            uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange, (Throwable)e);
        }
        if (uriString != null) {
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        HttpMethods answer = (m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET));
        return answer;
    }

    public static HttpVersion parserHttpVersion(String s) throws ProtocolException {
        int minor;
        int major;
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!s.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + s);
        }
        int i1 = "HTTP/".length();
        int i2 = s.indexOf(".", i1);
        if (i2 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + s);
        }
        try {
            major = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP major version number: " + s);
        }
        i1 = i2 + 1;
        i2 = s.length();
        try {
            minor = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP minor version number: " + s);
        }
        return new HttpVersion(major, minor);
    }

    public static boolean isSecureConnection(String uri) {
        return uri.startsWith("https");
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static Object extractHttpParameterValue(String value) {
        if (value == null || ObjectHelper.isEmpty((Object)value)) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String[] values;
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : values = trimmed.split(",")) {
                list.add(s.trim());
            }
            return list;
        }
        return value;
    }

    public static String urlRewrite(Exchange exchange, String url, HttpEndpoint endpoint, Producer producer) throws Exception {
        String answer = null;
        if (endpoint.getUrlRewrite() != null) {
            String newUrl;
            String baseUrl;
            String relativeUrl = endpoint.getHttpUri().toASCIIString();
            if (url.startsWith(relativeUrl)) {
                baseUrl = url.substring(0, relativeUrl.length());
                relativeUrl = url.substring(relativeUrl.length());
            } else {
                baseUrl = null;
                relativeUrl = url;
            }
            if (ObjectHelper.isEmpty((Object)relativeUrl)) {
                relativeUrl = null;
            }
            if (endpoint.getUrlRewrite() instanceof HttpServletUrlRewrite) {
                HttpMessage msg;
                Object request = (HttpServletRequest)exchange.getIn().getBody(HttpServletRequest.class);
                if (request == null && (msg = (HttpMessage)((Object)exchange.getIn(HttpMessage.class))) != null) {
                    request = msg.getRequest();
                }
                if (request == null) {
                    throw new IllegalArgumentException("UrlRewrite " + endpoint.getUrlRewrite() + " requires the message body to be a" + "HttpServletRequest instance, but was: " + ObjectHelper.className((Object)exchange.getIn().getBody()));
                }
                String contextPath = (String)exchange.getIn().getHeader("CamelServletContextPath", String.class);
                request = new UrlRewriteHttpServletRequestAdapter((HttpServletRequest)request, contextPath);
                newUrl = ((HttpServletUrlRewrite)endpoint.getUrlRewrite()).rewrite(url, relativeUrl, producer, (HttpServletRequest)request);
            } else {
                newUrl = endpoint.getUrlRewrite().rewrite(url, relativeUrl, producer);
            }
            if (ObjectHelper.isNotEmpty((Object)newUrl) && newUrl != url) {
                answer = newUrl.startsWith("http:") || newUrl.startsWith("https:") ? newUrl : (baseUrl != null ? (baseUrl.endsWith("/") && newUrl.startsWith("/") ? baseUrl + newUrl.substring(1) : baseUrl + newUrl) : newUrl);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using url rewrite to rewrite from url {} to {} -> {}", new Object[]{relativeUrl != null ? relativeUrl : url, newUrl, answer});
                }
            }
        }
        return answer;
    }
}

