/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.impl.DefaultExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class CamelContinuationServlet
extends CamelServlet {
    static final String EXCHANGE_ATTRIBUTE_NAME = "CamelExchange";
    static final String EXCHANGE_ATTRIBUTE_ID = "CamelExchangeId";
    private static final long serialVersionUID = 1L;
    private Long continuationTimeout;
    private final Map<String, String> expiredExchanges = new ConcurrentHashMap<String, String>();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Service: {}", (Object)request);
        HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            response.sendError(404);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().equals(request.getMethod())) {
            response.sendError(405);
            return;
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        Exchange result = (Exchange)request.getAttribute(EXCHANGE_ATTRIBUTE_NAME);
        if (result == null) {
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (continuation.isInitial() && this.continuationTimeout != null) {
                continuation.setTimeout(this.continuationTimeout.longValue());
            }
            if (consumer.isSuspended() && continuation.isInitial()) {
                response.sendError(503);
                return;
            }
            if (continuation.isExpired()) {
                String id = (String)continuation.getAttribute(EXCHANGE_ATTRIBUTE_ID);
                this.expiredExchanges.put(id, id);
                this.log.warn("Continuation expired of exchangeId: {}", (Object)id);
                response.sendError(503);
                return;
            }
            DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
            if (consumer.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
                exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
            }
            if (consumer.getEndpoint().isDisableStreamCache()) {
                exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
            }
            HttpHelper.setCharsetFromContentType((String)request.getContentType(), (Exchange)exchange);
            exchange.setIn((Message)new HttpMessage((Exchange)exchange, request, response));
            String contextPath = consumer.getEndpoint().getPath();
            exchange.getIn().setHeader("CamelServletContextPath", (Object)contextPath);
            String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
            if (contextPath != null && httpPath.startsWith(contextPath)) {
                exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(contextPath.length()));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Suspending continuation of exchangeId: {}", (Object)exchange.getExchangeId());
            }
            continuation.setAttribute(EXCHANGE_ATTRIBUTE_ID, (Object)exchange.getExchangeId());
            try {
                consumer.createUoW((Exchange)exchange);
            }
            catch (Exception e) {
                this.log.error("Error processing request", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            continuation.suspend();
            ClassLoader oldTccl = this.overrideTccl((Exchange)exchange);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            consumer.getAsyncProcessor().process((Exchange)exchange, new AsyncCallback((Exchange)exchange, continuation){
                final /* synthetic */ Exchange val$exchange;
                final /* synthetic */ Continuation val$continuation;
                {
                    this.val$exchange = exchange;
                    this.val$continuation = continuation;
                }

                public void done(boolean doneSync) {
                    boolean expired;
                    boolean bl = expired = CamelContinuationServlet.this.expiredExchanges.remove(this.val$exchange.getExchangeId()) != null;
                    if (!expired) {
                        if (CamelContinuationServlet.this.log.isTraceEnabled()) {
                            CamelContinuationServlet.this.log.trace("Resuming continuation of exchangeId: {}", (Object)this.val$exchange.getExchangeId());
                        }
                        this.val$continuation.setAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_NAME, (Object)this.val$exchange);
                        this.val$continuation.resume();
                    } else {
                        CamelContinuationServlet.this.log.warn("Cannot resume expired continuation of exchangeId: {}", (Object)this.val$exchange.getExchangeId());
                    }
                }
            });
            if (oldTccl != null) {
                this.restoreTccl((Exchange)exchange, oldTccl);
            }
            return;
        }
        try {
            Integer bs;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Resumed continuation and writing response for exchangeId: {}", (Object)result.getExchangeId());
            }
            if ((bs = consumer.getEndpoint().getResponseBufferSize()) != null) {
                this.log.trace("Using response buffer size: {}", (Object)bs);
                response.setBufferSize(bs.intValue());
            }
            consumer.getBinding().writeResponse(result, response);
        }
        catch (IOException e) {
            this.log.error("Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            consumer.doneUoW(result);
        }
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public void destroy() {
        this.expiredExchanges.clear();
        super.destroy();
    }
}

