/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyContentExchange
extends ContentExchange {
    private static final transient Log LOG = LogFactory.getLog(JettyContentExchange.class);
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private volatile Exchange exchange;
    private volatile AsyncCallback callback;
    private volatile JettyHttpBinding jettyBinding;
    private volatile HttpClient client;
    private final CountDownLatch done = new CountDownLatch(1);

    public JettyContentExchange(Exchange exchange, JettyHttpBinding jettyBinding, HttpClient client) {
        super(true);
        this.exchange = exchange;
        this.jettyBinding = jettyBinding;
        this.client = client;
    }

    public void setCallback(AsyncCallback callback) {
        this.callback = callback;
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        super.onResponseHeader(name, value);
        this.headers.put(name.toString(), value.toString());
    }

    protected void onRequestComplete() throws IOException {
        InputStream is = this.getRequestContentSource();
        if (is != null) {
            ObjectHelper.close((Closeable)is, (String)"RequestContentSource", (Log)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResponseComplete() throws IOException {
        try {
            super.onResponseComplete();
        }
        finally {
            this.doTaskCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExpire() {
        try {
            super.onExpire();
        }
        finally {
            this.doTaskCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(Throwable ex) {
        try {
            super.onException(ex);
        }
        finally {
            this.doTaskCompleted(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionFailed(Throwable ex) {
        try {
            super.onConnectionFailed(ex);
        }
        finally {
            this.doTaskCompleted(ex);
        }
    }

    protected int waitForDoneOrFailure() throws InterruptedException {
        long timeout = this.client.getTimeout() + 5000L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Waiting for done or failure with timeout: " + timeout));
        }
        this.done.await(timeout, TimeUnit.MILLISECONDS);
        return this.getStatus();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() throws UnsupportedEncodingException {
        return super.getResponseContent();
    }

    public String getUrl() {
        String params = this.getRequestFields().getStringField("Content-Encoding");
        return this.getScheme() + "//" + this.getAddress().toString() + this.getURI() + (params != null ? "?" + params : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted() {
        this.done.countDown();
        if (this.callback == null) {
            return;
        }
        int exchangeState = this.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("TaskComplete with state " + exchangeState + " for url: " + this.getUrl()));
        }
        try {
            if (exchangeState == 7) {
                try {
                    this.jettyBinding.populateResponse(this.exchange, this);
                }
                catch (Exception e) {
                    this.exchange.setException(e);
                }
            } else if (exchangeState == 8) {
                this.exchange.setException((Exception)new ExchangeTimedOutException(this.exchange, this.client.getTimeout()));
            } else if (this.exchange.getException() != null) {
                this.exchange.setException((Exception)new CamelExchangeException("JettyClient failed with state " + exchangeState, this.exchange));
            }
        }
        finally {
            this.callback.onTaskCompleted(this.exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted(Throwable ex) {
        try {
            this.exchange.setException((Exception)new CamelExchangeException("JettyClient failed cause by: " + ex.getMessage(), this.exchange, ex));
        }
        finally {
            this.done.countDown();
        }
        if (this.callback != null) {
            this.callback.onTaskCompleted(this.exchange);
        }
    }
}

