/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.impl.DefaultExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class CamelContinuationServlet
extends CamelServlet {
    static final String EXCHANGE_ATTRIBUTE_NAME = "CamelExchange";
    static final String EXCHANGE_ATTRIBUTE_ID = "CamelExchangeId";
    private static final long serialVersionUID = 1L;
    private Long continuationTimeout;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpConsumer consumer;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Service: " + request));
        }
        if ((consumer = this.resolve(request)) == null) {
            response.sendError(404);
            return;
        }
        Exchange result = (Exchange)request.getAttribute(EXCHANGE_ATTRIBUTE_NAME);
        if (result == null) {
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (this.continuationTimeout != null) {
                continuation.setTimeout(this.continuationTimeout.longValue());
            }
            if (consumer.isSuspended() && continuation.isInitial()) {
                response.sendError(503);
                return;
            }
            if (continuation.isExpired()) {
                String id = (String)continuation.getAttribute(EXCHANGE_ATTRIBUTE_ID);
                this.log.warn((Object)("Continuation expired of exchangeId: " + id));
                response.sendError(503);
                return;
            }
            DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
            if (consumer.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            }
            if (consumer.getEndpoint().isDisableStreamCache()) {
                exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
            }
            exchange.setIn((Message)new HttpMessage((Exchange)exchange, request, response));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Suspending continuation of exchangeId: " + exchange.getExchangeId()));
            }
            continuation.setAttribute(EXCHANGE_ATTRIBUTE_ID, (Object)exchange.getExchangeId());
            continuation.suspend();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Processing request for exchangeId: " + exchange.getExchangeId()));
            }
            consumer.getAsyncProcessor().process((Exchange)exchange, new AsyncCallback((Exchange)exchange, continuation){
                final /* synthetic */ Exchange val$exchange;
                final /* synthetic */ Continuation val$continuation;
                {
                    this.val$exchange = exchange;
                    this.val$continuation = continuation;
                }

                public void done(boolean doneSync) {
                    if (CamelContinuationServlet.this.log.isTraceEnabled()) {
                        CamelContinuationServlet.this.log.trace((Object)("Resuming continuation of exchangeId: " + this.val$exchange.getExchangeId()));
                    }
                    this.val$continuation.setAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_NAME, (Object)this.val$exchange);
                    this.val$continuation.resume();
                }
            });
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resumed continuation and writing response for exchangeId: " + result.getExchangeId()));
            }
            consumer.getBinding().writeResponse(result, response);
        }
        catch (IOException e) {
            this.log.error((Object)"Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }
}

