/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.Filter;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.jetty.DefaultJettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpProducer;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;

public class JettyHttpEndpoint
extends HttpEndpoint {
    private boolean sessionSupport;
    private List<Handler> handlers;
    private HttpClient client;
    private JettyHttpBinding jettyBinding;
    private boolean enableJmx;
    private boolean enableMultipartFilter;
    private Filter multipartFilter;
    private Long continuationTimeout;
    private Boolean useContinuation;
    private SSLContextParameters sslContextParameters;

    public JettyHttpEndpoint(JettyHttpComponent component, String uri, URI httpURL) throws URISyntaxException {
        super(uri, (HttpComponent)component, httpURL);
    }

    public JettyHttpComponent getComponent() {
        return (JettyHttpComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        JettyHttpProducer answer = new JettyHttpProducer((Endpoint)this, this.getClient());
        answer.setBinding(this.getJettyBinding());
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new HttpConsumer((HttpEndpoint)this, processor);
    }

    public void setSessionSupport(boolean support) {
        this.sessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public HttpClient getClient() throws Exception {
        if (this.client == null) {
            return this.getComponent().getHttpClient();
        }
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public synchronized JettyHttpBinding getJettyBinding() {
        if (this.jettyBinding == null) {
            this.jettyBinding = new DefaultJettyHttpBinding();
            this.jettyBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.jettyBinding.setThrowExceptionOnFailure(this.isThrowExceptionOnFailure());
            this.jettyBinding.setTransferException(this.isTransferException());
        }
        return this.jettyBinding;
    }

    public void setJettyBinding(JettyHttpBinding jettyBinding) {
        this.jettyBinding = jettyBinding;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableMultipartFilter() {
        return this.enableMultipartFilter;
    }

    public void setEnableMultipartFilter(boolean enableMultipartFilter) {
        this.enableMultipartFilter = enableMultipartFilter;
    }

    public void setMultipartFilter(Filter filter) {
        this.multipartFilter = filter;
    }

    public Filter getMultipartFilter() {
        return this.multipartFilter;
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public Boolean getUseContinuation() {
        return this.useContinuation;
    }

    public void setUseContinuation(Boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

