/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Message;
import org.apache.camel.component.jms.requestor.DeferredRequestReplyMap;
import org.apache.camel.component.jms.requestor.FutureHandler;
import org.apache.camel.component.jms.requestor.PersistentReplyToRequestor;

public class PersistentReplyToFutureHandler
extends FutureHandler {
    protected PersistentReplyToRequestor requestor;
    protected DeferredRequestReplyMap.DeferredMessageSentCallback callback;
    protected String correlationID;

    public PersistentReplyToFutureHandler(PersistentReplyToRequestor requestor, String correlationID) {
        this.requestor = requestor;
        this.correlationID = correlationID;
    }

    public PersistentReplyToFutureHandler(PersistentReplyToRequestor requestor, DeferredRequestReplyMap.DeferredMessageSentCallback callback) {
        this.requestor = requestor;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get() throws InterruptedException, ExecutionException {
        Message result = null;
        try {
            this.updateSelector();
            result = (Message)super.get();
        }
        finally {
            this.revertSelector();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Message result = null;
        try {
            this.updateSelector();
            result = (Message)super.get(timeout, unit);
        }
        finally {
            this.revertSelector();
        }
        return result;
    }

    protected void updateSelector() throws ExecutionException {
        try {
            PersistentReplyToRequestor.MessageSelectorComposer composer = (PersistentReplyToRequestor.MessageSelectorComposer)this.requestor.getListenerContainer();
            composer.addCorrelationID(this.correlationID != null ? this.correlationID : this.callback.getMessage().getJMSMessageID());
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    protected void revertSelector() throws ExecutionException {
        try {
            PersistentReplyToRequestor.MessageSelectorComposer composer = (PersistentReplyToRequestor.MessageSelectorComposer)this.requestor.getListenerContainer();
            composer.removeCorrelationID(this.correlationID != null ? this.correlationID : this.callback.getMessage().getJMSMessageID());
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }
}

