/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.jmx.JMXEndpoint;
import org.apache.camel.component.jmx.NotificationFormatException;
import org.apache.camel.component.jmx.NotificationXmlFormatter;
import org.apache.camel.impl.DefaultConsumer;

public class JMXConsumer
extends DefaultConsumer
implements NotificationListener {
    private MBeanServerConnection mServerConnection;
    private NotificationXmlFormatter mFormatter = new NotificationXmlFormatter();

    public JMXConsumer(JMXEndpoint aEndpoint, Processor aProcessor) {
        super((Endpoint)aEndpoint, aProcessor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        JMXEndpoint ep = (JMXEndpoint)this.getEndpoint();
        if (ep.isPlatformServer()) {
            this.setServerConnection(ManagementFactory.getPlatformMBeanServer());
        } else {
            JMXServiceURL url = new JMXServiceURL(ep.getServerURL());
            String[] creds = new String[]{ep.getUser(), ep.getPassword()};
            Map<String, String[]> map = Collections.singletonMap("jmx.remote.credentials", creds);
            JMXConnector connector = JMXConnectorFactory.connect(url, map);
            this.setServerConnection(connector.getMBeanServerConnection());
        }
        this.addNotificationListener();
    }

    protected void addNotificationListener() throws Exception {
        JMXEndpoint ep = (JMXEndpoint)this.getEndpoint();
        NotificationFilter nf = ep.getNotificationFilter();
        ObjectName objectName = ep.getJMXObjectName();
        this.getServerConnection().addNotificationListener(objectName, this, nf, ep.getHandback());
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeNotificationListener();
    }

    protected void removeNotificationListener() throws Exception {
        JMXEndpoint ep = (JMXEndpoint)this.getEndpoint();
        this.getServerConnection().removeNotificationListener(ep.getJMXObjectName(), this);
    }

    protected MBeanServerConnection getServerConnection() {
        return this.mServerConnection;
    }

    protected void setServerConnection(MBeanServerConnection aServerConnection) {
        this.mServerConnection = aServerConnection;
    }

    @Override
    public void handleNotification(Notification aNotification, Object aHandback) {
        JMXEndpoint ep = (JMXEndpoint)this.getEndpoint();
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        Message message = exchange.getIn();
        message.setHeader("jmx.handback", aHandback);
        try {
            if (ep.isXML()) {
                message.setBody((Object)this.getFormatter().format(aNotification));
            } else {
                message.setBody((Object)aNotification);
            }
            this.getProcessor().process(exchange);
        }
        catch (NotificationFormatException e) {
            this.getExceptionHandler().handleException("Failed to marshal notification", (Throwable)e);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Failed to process notification", (Throwable)e);
        }
    }

    protected NotificationXmlFormatter getFormatter() {
        return this.mFormatter;
    }
}

