/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jpa.springboot;

import javax.persistence.EntityManagerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * The jpa component enables you to store and retrieve Java objects from
 * databases using JPA.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.jpa")
public class JpaComponentConfiguration {

    /**
     * To use the EntityManagerFactory. This is strongly recommended to
     * configure.
     */
    private EntityManagerFactory entityManagerFactory;
    /**
     * To use the PlatformTransactionManager for managing transactions.
     */
    private PlatformTransactionManager transactionManager;
    /**
     * The camel-jpa component will join transaction by default. You can use
     * this option to turn this off for example if you use LOCAL_RESOURCE and
     * join transaction doesn't work with your JPA provider. This option can
     * also be set globally on the JpaComponent instead of having to set it on
     * all endpoints.
     */
    private Boolean joinTransaction;
    /**
     * Whether to use Spring's SharedEntityManager for the consumer/producer.
     * Note in most cases joinTransaction should be set to false as this is not
     * an EXTENDED EntityManager.
     */
    private Boolean sharedEntityManager;

    public EntityManagerFactory getEntityManagerFactory() {
        return entityManagerFactory;
    }

    public void setEntityManagerFactory(
            EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        return transactionManager;
    }

    public void setTransactionManager(
            PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Boolean getJoinTransaction() {
        return joinTransaction;
    }

    public void setJoinTransaction(Boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public Boolean getSharedEntityManager() {
        return sharedEntityManager;
    }

    public void setSharedEntityManager(Boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }
}