/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaComponent
extends DefaultComponent {
    private static final Log LOG = LogFactory.getLog(JpaComponent.class);
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> options) throws Exception {
        Class type;
        JpaEndpoint endpoint = new JpaEndpoint(uri, this);
        if (path != null && (type = this.getCamelContext().getClassResolver().resolveClass(path, JpaComponent.class.getClassLoader())) != null) {
            endpoint.setEntityType(type);
        }
        return endpoint;
    }

    protected void doStart() throws Exception {
        Map map;
        if (this.entityManagerFactory == null) {
            map = this.getCamelContext().getRegistry().lookupByType(EntityManagerFactory.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.entityManagerFactory = (EntityManagerFactory)map.values().iterator().next();
                    LOG.info((Object)("Using EntityManagerFactory found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.entityManagerFactory));
                } else {
                    LOG.debug((Object)("Could not find a single EntityManagerFactory in registry as there was " + map.size() + " instances."));
                }
            }
        } else {
            LOG.info((Object)("Using EntityManagerFactory configured: " + this.entityManagerFactory));
        }
        if (this.transactionManager == null) {
            map = this.getCamelContext().getRegistry().lookupByType(PlatformTransactionManager.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.transactionManager = (PlatformTransactionManager)map.values().iterator().next();
                    LOG.info((Object)("Using TransactionManager found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.transactionManager));
                } else {
                    LOG.debug((Object)("Could not find a single TransactionManager in registry as there was " + map.size() + " instances."));
                }
            }
        } else {
            LOG.info((Object)("Using TransactionManager configured on this component: " + this.transactionManager));
        }
        if (this.transactionManager == null && (map = this.getCamelContext().getRegistry().lookupByType(TransactionTemplate.class)) != null) {
            if (map.size() == 1) {
                this.transactionManager = ((TransactionTemplate)map.values().iterator().next()).getTransactionManager();
                LOG.info((Object)("Using TransactionManager found in registry with id [" + (String)map.keySet().iterator().next() + "] " + this.transactionManager));
            } else {
                LOG.debug((Object)("Could not find a single TransactionTemplate in registry as there was " + map.size() + " instances."));
            }
        }
        if (this.entityManagerFactory == null) {
            LOG.warn((Object)"No EntityManagerFactory has been configured on this JpaComponent. Each JpaEndpoint will auto create their own EntityManagerFactory.");
        }
        if (this.transactionManager == null) {
            LOG.warn((Object)"No TransactionManager has been configured on this JpaComponent. Each JpaEndpoint will auto create their own JpaTransactionManager.");
        }
        super.doStart();
    }
}

