/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.orm.jpa.JpaCallback;

public class JpaProducer
extends DefaultProducer {
    private final TransactionStrategy template;
    private final JpaEndpoint endpoint;
    private final Expression expression;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.expression = expression;
        this.template = endpoint.createTransactionStrategy();
    }

    public void process(final Exchange exchange) {
        exchange.getIn().setHeader("CamelJpaTemplate", (Object)this.endpoint.getTemplate());
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.template.execute(new JpaCallback(){

                public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        for (int index = 0; index < array.length; ++index) {
                            Object managedEntity = this.save(array[index], entityManager);
                            if (JpaProducer.this.endpoint.isUsePersist()) continue;
                            array[index] = managedEntity;
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        ArrayList<Object> managedEntities = new ArrayList<Object>();
                        Iterator iter = collection.iterator();
                        while (iter.hasNext()) {
                            Object managedEntity = this.save(iter.next(), entityManager);
                            managedEntities.add(managedEntity);
                        }
                        if (!JpaProducer.this.endpoint.isUsePersist()) {
                            collection.clear();
                            collection.addAll(managedEntities);
                        }
                    } else {
                        Object managedEntity = this.save(values, entityManager);
                        if (!JpaProducer.this.endpoint.isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.endpoint.isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }

                private Object save(Object entity, EntityManager entityManager) {
                    if (JpaProducer.this.endpoint.isUsePersist()) {
                        entityManager.persist(entity);
                        return entity;
                    }
                    return entityManager.merge(entity);
                }
            });
        }
        exchange.getIn().removeHeader("CamelJpaTemplate");
    }
}

