/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaCallback;

public class JpaConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(JpaConsumer.class);
    private final JpaEndpoint endpoint;
    private final TransactionStrategy template;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private Class<?> resultClass;
    private int maxMessagesPerPoll;
    private volatile ShutdownRunningTask shutdownRunningTask;
    private volatile int pendingExchanges;

    public JpaConsumer(JpaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.template = endpoint.createTransactionStrategy();
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        Object messagePolled = this.template.execute(new JpaCallback<Object>(){

            public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                int messagePolled;
                LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
                Query query = JpaConsumer.this.getQueryFactory().createQuery(entityManager);
                JpaConsumer.this.configureParameters(query);
                List results = CastUtils.cast((List)query.getResultList());
                for (Object result : results) {
                    DataHolder holder = new DataHolder();
                    holder.manager = entityManager;
                    holder.result = result;
                    holder.exchange = JpaConsumer.this.createExchange(result);
                    answer.add(holder);
                }
                try {
                    messagePolled = JpaConsumer.this.processBatch(CastUtils.cast(answer));
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
                entityManager.flush();
                return messagePolled;
            }
        });
        return (Integer)this.endpoint.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, messagePolled);
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll.");
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
            EntityManager entityManager = holder.manager;
            Exchange exchange = holder.exchange;
            Object result = holder.result;
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            if (!this.lockEntity(result, entityManager)) continue;
            LOG.debug("Processing exchange: {}", (Object)exchange);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
            this.getDeleteHandler().deleteObject(entityManager, result);
        }
        return total;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        if (ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask) {
            return this.pendingExchanges;
        }
        return 0;
    }

    public void prepareShutdown() {
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public JpaEndpoint getEndpoint() {
        return this.endpoint;
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler<Object> getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<Object> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    protected boolean lockEntity(Object entity, EntityManager entityManager) {
        if (!this.getEndpoint().isConsumeDelete() || !this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            LOG.debug("Acquiring exclusive lock on entity: {}", entity);
            entityManager.lock(entity, LockModeType.WRITE);
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to achieve lock on entity: " + entity + ". Reason: " + e, (Throwable)e);
            }
            return entity.getClass().isArray();
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            if (this.resultClass != null) {
                return QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass);
            }
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.endpoint.getEntityType();
        if (entityType == null) {
            return null;
        }
        String name = this.getEntityName(entityType);
        if (name != null) {
            return QueryBuilder.query("select x from " + name + " x");
        }
        return QueryBuilder.query("select x from " + entityType.getSimpleName() + " x");
    }

    protected String getEntityName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().equals("")) {
            return entity.name();
        }
        return null;
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = (Method)methods.get(0);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean) {
                        ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return new DeleteHandler<Object>(){

                @Override
                public void deleteObject(EntityManager entityManager, Object entityBean) {
                    entityManager.remove(entityBean);
                }
            };
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean) {
            }
        };
    }

    protected void configureParameters(Query query) {
        int maxResults = this.endpoint.getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
    }

    protected Exchange createExchange(Object result) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody(result);
        exchange.getIn().setHeader("CamelJpaTemplate", (Object)this.endpoint.getTemplate());
        return exchange;
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object result;
        private EntityManager manager;

        private DataHolder() {
        }
    }
}

