/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.jta.JtaTransactionErrorHandler;
import org.apache.camel.jta.JtaTransactionErrorHandlerBuilder;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.reifier.TransactedReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionErrorHandlerReifier
extends ErrorHandlerReifier<JtaTransactionErrorHandlerBuilder> {
    public static final String ROLLBACK_LOGGING_LEVEL_PROPERTY = JtaTransactionErrorHandlerBuilder.class.getName() + "#rollbackLoggingLevel";
    private static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionErrorHandlerReifier.class);

    public JtaTransactionErrorHandlerReifier(Route route, ErrorHandlerFactory definition) {
        super(route, (ErrorHandlerFactory)((JtaTransactionErrorHandlerBuilder)definition));
    }

    public Processor createErrorHandler(Processor processor) throws Exception {
        TransactedPolicy policy;
        JtaTransactionPolicy transactionPolicy = ((JtaTransactionErrorHandlerBuilder)this.definition).getTransactionPolicy();
        if (transactionPolicy == null && ((JtaTransactionErrorHandlerBuilder)this.definition).getPolicyRef() != null) {
            TransactedDefinition transactedDefinition = new TransactedDefinition();
            transactedDefinition.setRef(((JtaTransactionErrorHandlerBuilder)this.definition).getPolicyRef());
            policy = new TransactedReifier(this.camelContext, (ProcessorDefinition)transactedDefinition).resolvePolicy();
            if (policy != null) {
                if (!(policy instanceof JtaTransactionPolicy)) {
                    throw new RuntimeCamelException("The configured policy '" + ((JtaTransactionErrorHandlerBuilder)this.definition).getPolicyRef() + "' is of type '" + policy.getClass().getName() + "' but an instance of '" + JtaTransactionPolicy.class.getName() + "' is required!");
                }
                transactionPolicy = (JtaTransactionPolicy)policy;
            }
        }
        if (transactionPolicy == null) {
            LOG.debug("No transaction policy configured on TransactionErrorHandlerBuilder. Will try find it in the registry.");
            Map mapPolicy = this.findByTypeWithName(TransactedPolicy.class);
            if (mapPolicy != null && mapPolicy.size() == 1 && (policy = (TransactedPolicy)mapPolicy.values().iterator().next()) instanceof JtaTransactionPolicy) {
                transactionPolicy = (JtaTransactionPolicy)policy;
            }
            if (transactionPolicy == null && (policy = (TransactedPolicy)this.lookupByNameAndType(PROPAGATION_REQUIRED, TransactedPolicy.class)) instanceof JtaTransactionPolicy) {
                transactionPolicy = (JtaTransactionPolicy)policy;
            }
            if (transactionPolicy != null) {
                LOG.debug("Found TransactionPolicy in registry to use: {}", (Object)transactionPolicy);
            }
        }
        ObjectHelper.notNull((Object)transactionPolicy, (String)"transactionPolicy", (Object)((Object)this));
        Map properties = this.camelContext.getGlobalOptions();
        LoggingLevel rollbackLoggingLevel = ((JtaTransactionErrorHandlerBuilder)this.definition).getRollbackLoggingLevel();
        if (properties != null && properties.containsKey(ROLLBACK_LOGGING_LEVEL_PROPERTY)) {
            rollbackLoggingLevel = LoggingLevel.valueOf((String)((String)properties.get(ROLLBACK_LOGGING_LEVEL_PROPERTY)));
        }
        JtaTransactionErrorHandler answer = new JtaTransactionErrorHandler(this.camelContext, processor, ((JtaTransactionErrorHandlerBuilder)this.definition).getLogger(), ((JtaTransactionErrorHandlerBuilder)this.definition).getOnRedelivery(), ((JtaTransactionErrorHandlerBuilder)this.definition).getRedeliveryPolicy(), transactionPolicy, ((JtaTransactionErrorHandlerBuilder)this.definition).getRetryWhilePolicy(this.camelContext), this.getExecutorService(), rollbackLoggingLevel, ((JtaTransactionErrorHandlerBuilder)this.definition).getOnExceptionOccurred());
        this.configure((ErrorHandler)answer);
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService executorService = ((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorService();
        if (executorService == null || executorService.isShutdown()) {
            if (((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorServiceRef() != null) {
                executorService = (ScheduledExecutorService)this.lookupByNameAndType(((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorServiceRef(), ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorServiceRef());
                    executorService = manager.newScheduledThreadPool((Object)this, ((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorServiceRef(), profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorServiceRef " + ((JtaTransactionErrorHandlerBuilder)this.definition).getExecutorServiceRef() + " not found in registry.");
                }
            } else {
                executorService = null;
            }
        }
        return executorService;
    }
}

