/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.JtaTransactionErrorHandlerBuilder;
import org.apache.camel.jta.JtaTransactionErrorHandler;
import org.apache.camel.jta.JtaTransactionErrorHandlerReifier;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.errorhandler.ErrorHandlerHelper;
import org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.TransactedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JtaTransactionPolicy
implements TransactedPolicy {
    private static final Logger LOG;

    public void beforeWrap(Route route, NamedNode definition) {
        ((ProcessorDefinition)definition).setInheritErrorHandler(Boolean.valueOf(false));
    }

    public abstract void run(Runnable var1) throws Throwable;

    public Processor wrap(Route route, Processor processor) {
        JtaTransactionErrorHandlerDefinition txBuilder;
        RefErrorHandlerDefinition builderRef;
        String ref;
        RouteDefinition routeDefinition = (RouteDefinition)route.getRoute();
        ErrorHandlerFactory builder = routeDefinition.getErrorHandlerFactory();
        if (builder instanceof RefErrorHandlerDefinition && ErrorHandlerHelper.isErrorHandlerFactoryConfigured((String)(ref = (builderRef = (RefErrorHandlerDefinition)builder).getRef()))) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = ErrorHandlerHelper.lookupErrorHandlerFactory((Route)route, (String)ref, (boolean)true);
        }
        if (builder != null && builder.supportTransacted()) {
            if (!(builder instanceof JtaTransactionErrorHandlerDefinition)) {
                throw new RuntimeCamelException("The given transactional error handler builder '" + builder + "' is not of type '" + JtaTransactionErrorHandlerDefinition.class.getName() + "' which is required in this environment!");
            }
            LOG.debug("The ErrorHandlerBuilder configured is a JtaTransactionErrorHandlerDefinition: {}", (Object)builder);
            txBuilder = (JtaTransactionErrorHandlerDefinition)builder.cloneBuilder();
        } else {
            LOG.debug("No or no transactional ErrorHandlerBuilder configured, will use default JtaTransactionErrorHandlerDefinition settings");
            txBuilder = new JtaTransactionErrorHandlerDefinition();
        }
        txBuilder.setTransactedPolicy((Object)this);
        if (builder != null) {
            route.addErrorHandlerFactoryReference(builder, (ErrorHandlerFactory)txBuilder);
        }
        JtaTransactionErrorHandler answer = this.createTransactionErrorHandler(route, processor, (ErrorHandlerFactory)txBuilder);
        route.setErrorHandlerFactory((ErrorHandlerFactory)txBuilder);
        return answer;
    }

    protected JtaTransactionErrorHandler createTransactionErrorHandler(Route route, Processor processor, ErrorHandlerFactory builder) {
        JtaTransactionErrorHandler answer;
        try {
            ModelCamelContext mcc = (ModelCamelContext)route.getCamelContext().adapt(ModelCamelContext.class);
            answer = (JtaTransactionErrorHandler)mcc.getModelReifierFactory().createErrorHandler(route, builder, processor);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public String toString() {
        return this.getClass().getName();
    }

    static {
        ErrorHandlerReifier.registerReifier(JtaTransactionErrorHandlerBuilder.class, (route, errorHandlerFactory) -> new JtaTransactionErrorHandlerReifier((Route)route, (JtaTransactionErrorHandlerDefinition)errorHandlerFactory));
        ErrorHandlerReifier.registerReifier(JtaTransactionErrorHandlerDefinition.class, (route, errorHandlerFactory) -> new JtaTransactionErrorHandlerReifier((Route)route, (JtaTransactionErrorHandlerDefinition)errorHandlerFactory));
        LOG = LoggerFactory.getLogger(JtaTransactionPolicy.class);
    }

    public static interface Runnable {
        public void run() throws Throwable;
    }
}

