/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.camel.component.kafka.consumer.KafkaAsyncManualCommit;
import org.apache.camel.component.kafka.consumer.KafkaManualCommit;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCommitManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncCommitManager.class);
    private final Consumer<?, ?> consumer;
    private final ConcurrentLinkedQueue<KafkaAsyncManualCommit> asyncCommits = new ConcurrentLinkedQueue();

    public AsyncCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
        this.consumer = consumer;
    }

    @Override
    @Deprecated
    public void processAsyncCommits() {
        while (!this.asyncCommits.isEmpty()) {
            this.asyncCommits.poll().processAsyncCommit();
        }
    }

    @Override
    public void commit() {
        this.processAsyncCommits();
        if (this.kafkaConsumer.getEndpoint().getConfiguration().isAutoCommitEnable()) {
            LOG.info("Auto commitAsync {} from {}", (Object)this.threadId, (Object)this.printableTopic);
            this.consumer.commitAsync();
        }
    }

    @Override
    public void commitOffsetOnStop(TopicPartition partition, long partitionLastOffset) {
        this.commitAsync(this.consumer, partition, partitionLastOffset);
    }

    @Override
    public void commitOffset(TopicPartition partition, long partitionLastOffset) {
    }

    private void commitAsync(Consumer<?, ?> consumer, TopicPartition partition, long partitionLastOffset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commitAsync on stop {} from topic {}", (Object)this.threadId, (Object)partition.topic());
        }
        consumer.commitAsync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)), null);
    }

    @Override
    public KafkaManualCommit getManualCommit(Exchange exchange, TopicPartition partition, ConsumerRecord<Object, Object> record) {
        KafkaManualCommitFactory manualCommitFactory = this.kafkaConsumer.getEndpoint().getKafkaManualCommitFactory();
        return this.getManualCommit(exchange, partition, record, this.asyncCommits, manualCommitFactory);
    }
}

