/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AsyncCommitManager;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.CommitToOffsetManager;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualAsyncCommitFactory;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.consumer.NoopCommitManager;
import org.apache.camel.component.kafka.consumer.SyncCommitManager;
import org.apache.kafka.clients.consumer.Consumer;

public final class CommitManagers {
    private CommitManagers() {
    }

    public static CommitManager createCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        KafkaManualCommitFactory manualCommitFactory;
        KafkaConfiguration configuration = kafkaConsumer.getEndpoint().getConfiguration();
        if (!configuration.isAllowManualCommit() && configuration.getOffsetRepository() != null) {
            return new CommitToOffsetManager(consumer, kafkaConsumer, threadId, printableTopic);
        }
        if (configuration.isAutoCommitEnable()) {
            if ("async".equals(configuration.getAutoCommitOnStop())) {
                return new AsyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
            }
            if ("sync".equals(configuration.getAutoCommitOnStop())) {
                return new SyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
            }
            if ("none".equals(configuration.getAutoCommitOnStop())) {
                return new NoopCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
            }
        }
        if ((manualCommitFactory = kafkaConsumer.getEndpoint().getKafkaManualCommitFactory()) instanceof DefaultKafkaManualAsyncCommitFactory) {
            return new AsyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
        }
        return new NoopCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
    }
}

