/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitToOffsetManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(CommitToOffsetManager.class);
    private final StateRepository<String, String> offsetRepository;

    public CommitToOffsetManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
        this.offsetRepository = this.configuration.getOffsetRepository();
    }

    @Override
    public void commitOffsetOnStop(TopicPartition partition, long partitionLastOffset) {
        this.saveStateToOffsetRepository(partition, partitionLastOffset, this.offsetRepository);
    }

    @Override
    public void commitOffset(TopicPartition partition, long partitionLastOffset) {
        if (partitionLastOffset == -1L) {
            return;
        }
        this.saveStateToOffsetRepository(partition, partitionLastOffset, this.offsetRepository);
    }

    @Override
    public void commitOffsetForce(TopicPartition partition, long partitionLastOffset) {
        this.saveStateToOffsetRepository(partition, partitionLastOffset, this.offsetRepository);
    }

    private void saveStateToOffsetRepository(TopicPartition partition, long partitionLastOffset, StateRepository<String, String> offsetRepository) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving offset repository state {} [topic: {} partition: {} offset: {}]", new Object[]{this.threadId, partition.topic(), partition.partition(), partitionLastOffset});
        }
        offsetRepository.setState((Object)CommitToOffsetManager.serializeOffsetKey(partition), (Object)CommitToOffsetManager.serializeOffsetValue(partitionLastOffset));
    }

    @Override
    public void commit() {
    }

    private static String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + "/" + topicPartition.partition();
    }

    private static String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }
}

