/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NonManagedService;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupStep;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ModelLifecycleStrategySupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.ExtendedRoutesBuilderLoader;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesConfigurer
extends ServiceSupport
implements NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesConfigurer.class);
    private final DuplicateRouteDetector detector = new DuplicateRouteDetector();
    private final CamelContext camelContext;
    private RoutesCollector routesCollector;
    private boolean ignoreLoadingError;
    private CamelBeanPostProcessor beanPostProcessor;
    private List<RoutesBuilder> routesBuilders;
    private String basePackageScan;
    private String routesBuilderClasses;
    private String javaRoutesExcludePattern;
    private String javaRoutesIncludePattern;
    private String routesExcludePattern;
    private String routesIncludePattern;
    private String routesSourceDir;

    public RoutesConfigurer(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isIgnoreLoadingError() {
        return this.ignoreLoadingError;
    }

    public void setIgnoreLoadingError(boolean ignoreLoadingError) {
        this.ignoreLoadingError = ignoreLoadingError;
    }

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String routesBuilderClasses) {
        this.routesBuilderClasses = routesBuilderClasses;
    }

    public String getJavaRoutesExcludePattern() {
        return this.javaRoutesExcludePattern;
    }

    public void setJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
        this.javaRoutesExcludePattern = javaRoutesExcludePattern;
    }

    public String getJavaRoutesIncludePattern() {
        return this.javaRoutesIncludePattern;
    }

    public void setJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
        this.javaRoutesIncludePattern = javaRoutesIncludePattern;
    }

    public String getRoutesExcludePattern() {
        return this.routesExcludePattern;
    }

    public void setRoutesExcludePattern(String routesExcludePattern) {
        this.routesExcludePattern = routesExcludePattern;
    }

    public String getRoutesIncludePattern() {
        return this.routesIncludePattern;
    }

    public void setRoutesIncludePattern(String routesIncludePattern) {
        this.routesIncludePattern = routesIncludePattern;
    }

    public String getRoutesSourceDir() {
        return this.routesSourceDir;
    }

    public void setRoutesSourceDir(String routesSourceDir) {
        this.routesSourceDir = routesSourceDir;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public CamelBeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        this.beanPostProcessor = beanPostProcessor;
    }

    protected void doStart() throws Exception {
        ((Model)this.camelContext.getCamelContextExtension().getContextPlugin(Model.class)).addModelLifecycleStrategy((ModelLifecycleStrategy)this.detector);
    }

    protected void doStop() throws Exception {
        this.detector.clear();
        ((Model)this.camelContext.getCamelContextExtension().getContextPlugin(Model.class)).removeModelLifecycleStrategy((ModelLifecycleStrategy)this.detector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureRoutes(CamelContext camelContext) throws Exception {
        StartupStep step;
        ArrayList<RoutesBuilder> routes;
        StartupStepRecorder recorder;
        block29: {
            recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
            routes = new ArrayList<RoutesBuilder>();
            if (this.getRoutesBuilders() != null) {
                routes.addAll(this.getRoutesBuilders());
            }
            if (this.getRoutesBuilderClasses() != null) {
                String[] routeClasses;
                step = recorder.beginStep(RoutesConfigurer.class, "resolveRoutesBuilderClasses", "Routes Configurer");
                for (String routeClass : routeClasses = this.getRoutesBuilderClasses().split(",")) {
                    try {
                        Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass, RoutesBuilder.class);
                        if (routeClazz == null) {
                            LOG.warn("Unable to resolve class: {}", (Object)routeClass);
                            continue;
                        }
                        RoutesBuilder builder = (RoutesBuilder)camelContext.getInjector().newInstance(routeClazz, false);
                        routes.add(builder);
                    }
                    catch (Exception e) {
                        if (this.isIgnoreLoadingError()) {
                            LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                            continue;
                        }
                        throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                    }
                }
                recorder.endStep(step);
            }
            if (this.getBasePackageScan() != null) {
                String[] excludes;
                step = recorder.beginStep(RoutesConfigurer.class, "packageScan", "Routes Configurer");
                boolean scan = true;
                String[] includes = this.javaRoutesIncludePattern != null ? this.javaRoutesIncludePattern.split(",") : null;
                String[] stringArray = excludes = this.javaRoutesExcludePattern != null ? this.javaRoutesExcludePattern.split(",") : null;
                if (includes != null && ObjectHelper.equal((Object)"false", (Object)this.javaRoutesIncludePattern)) {
                    scan = false;
                }
                if (scan) {
                    String[] pkgs = this.getBasePackageScan().split(",");
                    Set set = PluginHelper.getPackageScanClassResolver((CamelContext)camelContext).findImplementations(RoutesBuilder.class, pkgs);
                    for (Class routeClazz : set) {
                        String path = routeClazz.getName().replace(".", "/");
                        if (excludes != null && !"false".equals(this.javaRoutesExcludePattern) && AntPathMatcher.INSTANCE.anyMatch(excludes, path) || includes != null && !"false".equals(this.javaRoutesIncludePattern) && !AntPathMatcher.INSTANCE.anyMatch(includes, path)) continue;
                        try {
                            Object builder = camelContext.getInjector().newInstance(routeClazz, false);
                            if (builder instanceof RoutesBuilder) {
                                RoutesBuilder routesBuilder = (RoutesBuilder)builder;
                                routes.add(routesBuilder);
                                continue;
                            }
                            LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
                        }
                        catch (Exception e) {
                            if (this.isIgnoreLoadingError()) {
                                LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                                continue;
                            }
                            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                        }
                    }
                }
                recorder.endStep(step);
            }
            if (this.getRoutesCollector() != null) {
                step = recorder.beginStep(RoutesConfigurer.class, "routesCollector", "Routes Configurer");
                try {
                    LOG.debug("RoutesCollectorEnabled: {}", (Object)this.getRoutesCollector());
                    Collection<RoutesBuilder> routesFromRegistry = this.getRoutesCollector().collectRoutesFromRegistry(camelContext, this.getJavaRoutesExcludePattern(), this.getJavaRoutesIncludePattern());
                    routes.addAll(routesFromRegistry);
                    if (LOG.isDebugEnabled() && !routesFromRegistry.isEmpty()) {
                        LOG.debug("Discovered {} additional RoutesBuilder from registry: {}", (Object)routesFromRegistry.size(), (Object)this.getRoutesIncludePattern());
                    }
                    StopWatch watch = new StopWatch();
                    Collection<RoutesBuilder> routesFromDirectory = this.getRoutesCollector().collectRoutesFromDirectory(camelContext, this.getRoutesExcludePattern(), this.getRoutesIncludePattern());
                    routes.addAll(routesFromDirectory);
                    if (LOG.isDebugEnabled() && !routesFromDirectory.isEmpty()) {
                        LOG.debug("Loaded {} additional RoutesBuilder from: {} (took {})", new Object[]{routesFromDirectory.size(), this.getRoutesIncludePattern(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
                    }
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                        break block29;
                    }
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
                finally {
                    recorder.endStep(step);
                }
            }
        }
        if (this.getBeanPostProcessor() != null) {
            step = recorder.beginStep(RoutesConfigurer.class, "beanPostProcessor", "Routes Configurer");
            for (RoutesBuilder routeBuilder : routes) {
                try {
                    this.getBeanPostProcessor().postProcessBeforeInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
                    this.getBeanPostProcessor().postProcessAfterInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                        continue;
                    }
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            }
            recorder.endStep(step);
        }
        step = recorder.beginStep(RoutesConfigurer.class, "addDiscoveredRoutes", "Routes Configurer");
        this.addDiscoveredRoutes(camelContext, routes);
        recorder.endStep(step);
    }

    private void addDiscoveredRoutes(CamelContext camelContext, List<RoutesBuilder> routes) throws Exception {
        routes.sort((Comparator<RoutesBuilder>)OrderedComparator.get());
        this.detector.clear();
        for (RoutesBuilder builder : routes) {
            try {
                if (!(builder instanceof RouteConfigurationsBuilder)) continue;
                RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)builder;
                LOG.debug("Adding routes configurations into CamelContext from RouteConfigurationsBuilder: {}", (Object)rcb);
                camelContext.addRoutesConfigurations(rcb);
            }
            catch (Exception e) {
                if (this.isIgnoreLoadingError()) {
                    LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                    continue;
                }
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        for (RoutesBuilder builder : routes) {
            try {
                LOG.debug("Adding routes into CamelContext from RoutesBuilder: {}", (Object)builder);
                camelContext.addRoutes(builder);
            }
            catch (Exception e) {
                if (this.isIgnoreLoadingError()) {
                    LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                    continue;
                }
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        for (RoutesBuilder builder : routes) {
            try {
                LOG.debug("Adding templated routes into CamelContext from RoutesBuilder: {}", (Object)builder);
                camelContext.addTemplatedRoutes(builder);
            }
            catch (Exception e) {
                if (this.isIgnoreLoadingError()) {
                    LOG.warn("Ignore loading error due to: {}. This exception is ignored.", (Object)e.getMessage());
                    continue;
                }
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        List<String> ids = this.detector.getRouteIds();
        Set dups = ids.stream().filter(i -> Collections.frequency(ids, i) > 1).collect(Collectors.toSet());
        if (!dups.isEmpty()) {
            String id = String.join((CharSequence)",", dups);
            throw new FailedToCreateRouteException("Duplicate route ids detected: " + id + ". Please correct ids to be unique among all your routes.");
        }
    }

    public void configureModeline(CamelContext camelContext) throws Exception {
        if (this.getRoutesCollector() == null) {
            return;
        }
        try {
            LOG.debug("RoutesCollectorEnabled: {}", (Object)this.getRoutesCollector());
            String pattern = this.getRoutesIncludePattern();
            String optionalPattern = null;
            if (pattern != null && pattern.contains("?optional=true")) {
                StringJoiner sj1 = new StringJoiner(",");
                StringJoiner sj2 = new StringJoiner(",");
                for (String p : pattern.split(",")) {
                    if (p.endsWith("?optional=true")) {
                        sj2.add(p.substring(0, p.length() - 14));
                        continue;
                    }
                    sj1.add(p);
                }
                pattern = sj1.length() > 0 ? sj1.toString() : null;
                String string = optionalPattern = sj2.length() > 0 ? sj2.toString() : null;
            }
            if (optionalPattern == null) {
                Collection<Resource> resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), pattern);
                this.doConfigureModeline(camelContext, resources, false);
            } else {
                Collection<Resource> resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), optionalPattern);
                this.doConfigureModeline(camelContext, resources, true);
                if (pattern != null) {
                    resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), pattern);
                    this.doConfigureModeline(camelContext, resources, false);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConfigureModeline(CamelContext camelContext, Collection<Resource> resources, boolean optional) throws Exception {
        StartupStep step;
        StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
        ArrayList<Resource> sort = new ArrayList<Resource>(resources);
        sort.sort((o1, o2) -> {
            String ext1 = FileUtil.onlyExt((String)o1.getLocation(), (boolean)false);
            String ext2 = FileUtil.onlyExt((String)o2.getLocation(), (boolean)false);
            if ("java".equals(ext1)) {
                return -1;
            }
            if ("java".equals(ext2)) {
                return 1;
            }
            return 0;
        });
        LinkedHashMap<Object, List> groups = new LinkedHashMap<Object, List>();
        for (Resource resource : sort) {
            String string = FileUtil.onlyExt((String)resource.getLocation(), (boolean)false);
            step = recorder.beginStep(RoutesConfigurer.class, "resolveRoutesBuilderLoader:" + string, "Routes Configurer");
            try {
                RoutesBuilderLoader loader = this.resolveRoutesBuilderLoader(camelContext, resource, optional);
                if (loader == null) continue;
                List list = groups.getOrDefault(loader, new ArrayList());
                list.add(resource);
                groups.put(loader, list);
            }
            finally {
                recorder.endStep(step);
            }
        }
        step = recorder.beginStep(RoutesConfigurer.class, "parseModeline", "Routes Configurer");
        if (camelContext.isModeline().booleanValue()) {
            ModelineFactory factory = PluginHelper.getModelineFactory((CamelContext)camelContext);
            for (Map.Entry entry : groups.entrySet()) {
                for (Resource resource : (List)entry.getValue()) {
                    factory.parseModeline(resource);
                }
            }
        }
        recorder.endStep(step);
        for (Map.Entry entry : groups.entrySet()) {
            RoutesBuilderLoader routesBuilderLoader = (RoutesBuilderLoader)entry.getKey();
            if (routesBuilderLoader instanceof ExtendedRoutesBuilderLoader) {
                ExtendedRoutesBuilderLoader extLoader = (ExtendedRoutesBuilderLoader)routesBuilderLoader;
                List files = (List)entry.getValue();
                step = recorder.beginStep(RoutesConfigurer.class, "preParseRoutes", "Routes Configurer");
                try {
                    extLoader.preParseRoutes((Collection)files);
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Ignore loading error: {} due to: {}. This exception is ignored.", (Object)files, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
                finally {
                    recorder.endStep(step);
                    continue;
                }
            }
            for (Resource resource : (List)entry.getValue()) {
                step = recorder.beginStep(RoutesConfigurer.class, "preParseRoute:" + resource.getLocation(), "Routes Configurer");
                try {
                    routesBuilderLoader.preParseRoute(resource);
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Ignore loading error: {} due to: {}. This exception is ignored.", (Object)resource, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
                finally {
                    recorder.endStep(step);
                }
            }
        }
    }

    protected RoutesBuilderLoader resolveRoutesBuilderLoader(CamelContext camelContext, Resource resource, boolean optional) throws Exception {
        RoutesBuilderLoader answer = null;
        String extension = FileUtil.onlyExt((String)resource.getLocation(), (boolean)false);
        if (extension != null) {
            RoutesLoader loader = PluginHelper.getRoutesLoader((CamelContext)camelContext);
            answer = loader.getRoutesLoader(extension);
        }
        if (!optional && answer == null) {
            throw new IllegalArgumentException("Cannot find RoutesBuilderLoader in classpath supporting file extension: " + extension);
        }
        return answer;
    }

    private static class DuplicateRouteDetector
    extends ModelLifecycleStrategySupport {
        private final List<String> ids = new ArrayList<String>();

        private DuplicateRouteDetector() {
        }

        void clear() {
            this.ids.clear();
        }

        public List<String> getRouteIds() {
            return this.ids;
        }

        public void onAddRouteDefinition(RouteDefinition definition) {
            String id = definition.getRouteId();
            if (id == null || id.isEmpty()) {
                return;
            }
            if (definition.isInlined()) {
                return;
            }
            String prefix = definition.getNodePrefixId();
            if (prefix == null) {
                prefix = "";
            }
            String key = id + prefix;
            this.ids.add(key);
        }
    }
}

