/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedEndpointMBean;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Endpoint")
public class ManagedEndpoint
implements ManagedInstance,
ManagedEndpointMBean {
    private final Endpoint endpoint;

    public ManagedEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getCamelId() {
        return this.endpoint.getCamelContext().getName();
    }

    public String getCamelManagementName() {
        return this.endpoint.getCamelContext().getManagementName();
    }

    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    public String getEndpointBaseUri() {
        return this.endpoint.getEndpointBaseUri();
    }

    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    public String getState() {
        if (this.endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public Endpoint getInstance() {
        return this.endpoint;
    }
}

