/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoSession;

public class MinaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @Deprecated
    public static final transient String HEADER_MINA_IOSESSION = "CamelMinaIoSession";
    @Deprecated
    public static final transient String HEADER_LOCAL_ADDRESS = "CamelMinaLocalAddress";
    @Deprecated
    public static final transient String HEADER_REMOTE_ADDRESS = "CamelMinaRemoteAddress";
    private SocketAddress address;
    private IoAcceptor acceptor;
    private IoConnector connector;
    private IoAcceptorConfig acceptorConfig;
    private IoConnectorConfig connectorConfig;
    private MinaConfiguration configuration;
    private final List<ExecutorService> executors = new ArrayList<ExecutorService>();

    public MinaEndpoint() {
    }

    public MinaEndpoint(String endpointUri, MinaComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)this.address, (String)"address");
        ObjectHelper.notNull((Object)this.connector, (String)"connector");
        if (!this.configuration.getProtocol().equalsIgnoreCase("vm")) {
            ObjectHelper.notNull((Object)this.connectorConfig, (String)"connectorConfig");
        }
        return new MinaProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)this.address, (String)"address");
        ObjectHelper.notNull((Object)this.acceptor, (String)"acceptor");
        if (!this.configuration.getProtocol().equalsIgnoreCase("vm")) {
            ObjectHelper.notNull((Object)this.acceptorConfig, (String)"acceptorConfig");
        }
        return new MinaConsumer(this, processor);
    }

    public Exchange createExchange(IoSession session, Object payload) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setHeader(HEADER_MINA_IOSESSION, (Object)session);
        exchange.getIn().setHeader(HEADER_LOCAL_ADDRESS, (Object)session.getLocalAddress());
        exchange.getIn().setHeader(HEADER_REMOTE_ADDRESS, (Object)session.getRemoteAddress());
        MinaPayloadHelper.setIn(exchange, payload);
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return this.configuration.isDatagramProtocol();
    }

    protected void doShutdown() throws Exception {
        for (ExecutorService executor : this.executors) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(executor);
        }
        this.executors.clear();
        super.doShutdown();
    }

    protected void addThreadPool(ExecutorService executorService) {
        this.executors.add(executorService);
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(SocketAddress address) {
        this.address = address;
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public IoConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IoConnector connector) {
        this.connector = connector;
    }

    public IoAcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(IoAcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public IoConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(IoConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }
}

