/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty4.NettyProducer;
import org.apache.camel.component.netty4.handlers.ClientChannelHandler;
import org.apache.camel.component.netty4.http.NettyHttpProducer;

public class HttpClientChannelHandler
extends ClientChannelHandler {
    private final NettyHttpProducer producer;

    public HttpClientChannelHandler(NettyHttpProducer producer) {
        super((NettyProducer)producer);
        this.producer = producer;
    }

    protected Message getResponseMessage(Exchange exchange, ChannelHandlerContext ctx, Object message) throws Exception {
        FullHttpResponse response = (FullHttpResponse)message;
        if (!HttpUtil.isKeepAlive((HttpMessage)response)) {
            exchange.setProperty("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        return this.producer.getEndpoint().getNettyHttpBinding().toCamelMessage(response, exchange, this.producer.getConfiguration());
    }
}

