/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.handler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.oaipmh.component.model.OAIPMHVerb;
import org.apache.camel.oaipmh.handler.ResponseHandler;
import org.apache.camel.oaipmh.model.OAIPMHResponse;
import org.apache.camel.oaipmh.utils.OAIPMHHttpClient;
import org.xml.sax.SAXException;

public class Harvester {
    private static final String NO_TOKEN = null;
    private String resumptionToken = NO_TOKEN;
    private URI baseURI;
    private String verb;
    private String metadata;
    private String until;
    private String from;
    private String set;
    private String identifier;
    private OAIPMHHttpClient httpClient;
    private ResponseHandler oaipmhResponseHandler;
    private boolean empty;

    public Harvester(ResponseHandler oaipmhResponseHandler, URI baseURI, String verb, String metadata, String until, String from, String set, String identifier) {
        this.baseURI = baseURI;
        this.verb = verb;
        this.metadata = metadata;
        this.until = until;
        this.from = from;
        this.set = set;
        this.identifier = identifier;
        this.httpClient = new OAIPMHHttpClient();
        this.oaipmhResponseHandler = oaipmhResponseHandler;
        if (OAIPMHVerb.valueOf(verb) == OAIPMHVerb.ListMetadataFormats || OAIPMHVerb.valueOf(verb) == OAIPMHVerb.ListSets || OAIPMHVerb.valueOf(verb) == OAIPMHVerb.Identify) {
            this.metadata = null;
            this.until = null;
            this.from = null;
            this.set = null;
            this.identifier = null;
        }
    }

    private boolean harvest() throws IOException, URISyntaxException, ParserConfigurationException, SAXException, Exception {
        boolean hasNext = false;
        if (!this.empty) {
            String responseXML = this.httpClient.doRequest(this.baseURI, this.verb, this.set, this.from, this.until, this.metadata, this.resumptionToken, this.identifier);
            OAIPMHResponse oaipmhResponse = new OAIPMHResponse(responseXML);
            this.oaipmhResponseHandler.process(oaipmhResponse);
            Optional<String> resumptionToken = oaipmhResponse.getResumptionToken();
            if (resumptionToken.isPresent() && !resumptionToken.get().isEmpty()) {
                this.resumptionToken = resumptionToken.get();
                hasNext = true;
            } else {
                this.resumptionToken = null;
                this.empty = true;
            }
        }
        return hasNext;
    }

    public void asynHarvest() throws IOException, URISyntaxException, ParserConfigurationException, SAXException, Exception {
        this.harvest();
    }

    public List<String> synHarvest(boolean onlyFirst) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, Exception {
        while (this.harvest() && !onlyFirst) {
        }
        return this.oaipmhResponseHandler.flush();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public void setResumptionToken(String resumptionToken) {
        this.resumptionToken = resumptionToken;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSet() {
        return this.set;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public OAIPMHHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(OAIPMHHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

