/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.OtherModel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PrepareUserGuideMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File componentsDir;
    protected File dataFormatsDir;
    protected File languagesDir;
    protected File othersDir;
    protected File userGuideDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeComponents();
        this.executeOthers();
        this.executeDataFormats();
        this.executeLanguages();
    }

    protected void executeComponents() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (files = this.componentsDir.listFiles()) != null) {
            componentFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
            for (File file : componentFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                ComponentModel model = this.generateComponentModel(json);
                boolean add = true;
                if (!model.getAlternativeSchemes().isEmpty()) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) {
                        add = false;
                    }
                }
                if (!add) continue;
                models.add(model);
            }
            Collections.sort(models, (Comparator)new ComponentComparator());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder core = new StringBuilder();
            core.append("* Core Components\n");
            for (ComponentModel model : models) {
                if (!model.getLabel().contains("core")) continue;
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                core.append(line);
            }
            boolean updated = this.updateCoreComponents(file, core.toString());
            StringBuilder regular = new StringBuilder();
            regular.append("* Components\n");
            for (ComponentModel model : models) {
                if (model.getLabel().contains("core")) continue;
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                regular.append(line);
            }
            if (updated |= this.updateComponents(file, regular.toString())) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOthers() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.othersDir != null && this.othersDir.isDirectory() && (files = this.othersDir.listFiles()) != null) {
            otherFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<OtherModel> models = new ArrayList<OtherModel>();
            for (File file : otherFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                OtherModel model = this.generateOtherModel(json);
                models.add(model);
            }
            Collections.sort(models, (Comparator)new OtherComparator());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder other = new StringBuilder();
            other.append("* Miscellaneous Components\n");
            for (OtherModel model : models) {
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                other.append(line);
            }
            boolean updated = this.updateOthers(file, other.toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeDataFormats() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.dataFormatsDir != null && this.dataFormatsDir.isDirectory() && (files = this.dataFormatsDir.listFiles()) != null) {
            dataFormatFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
            for (File file : dataFormatFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                DataFormatModel model = this.generateDataFormatModel(json);
                models.add(model);
            }
            Collections.sort(models, (Comparator)new DataFormatComparator());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder dataFormats = new StringBuilder();
            dataFormats.append("* Data Formats\n");
            for (DataFormatModel model : models) {
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                dataFormats.append(line);
            }
            boolean updated = this.updateDataFormats(file, dataFormats.toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeLanguages() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.languagesDir != null && this.languagesDir.isDirectory() && (files = this.languagesDir.listFiles()) != null) {
            languageFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
            for (File file : languageFiles) {
                String json = PackageHelper.loadText(new FileInputStream(file));
                LanguageModel model = this.generateLanguageModel(json);
                models.add(model);
            }
            Collections.sort(models, (Comparator)new LanguageComparator());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder languages = new StringBuilder();
            languages.append("* Expression Languages\n");
            for (LanguageModel model : models) {
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                languages.append(line);
            }
            boolean updated = this.updateLanguages(file, languages.toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean updateCoreComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "<!-- core components: START -->", "<!-- core components: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "<!-- core components: START -->");
                String after = StringHelper.after(text, "<!-- core components: END -->");
                text = before + "<!-- core components: START -->\n" + changed + "\n<!-- core components: END -->" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- core components: START -->");
            this.getLog().warn((CharSequence)"\t<!-- core components: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "<!-- components: START -->", "<!-- components: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "<!-- components: START -->");
                String after = StringHelper.after(text, "<!-- components: END -->");
                text = before + "<!-- components: START -->\n" + changed + "\n<!-- components: END -->" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- components: START -->");
            this.getLog().warn((CharSequence)"\t<!-- components: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateOthers(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "<!-- others: START -->", "<!-- others: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "<!-- others: START -->");
                String after = StringHelper.after(text, "<!-- others: END -->");
                text = before + "<!-- others: START -->\n" + changed + "\n<!-- others: END -->" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- others: START -->");
            this.getLog().warn((CharSequence)"\t<!-- others: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormats(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "<!-- dataformats: START -->", "<!-- dataformats: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "<!-- dataformats: START -->");
                String after = StringHelper.after(text, "<!-- dataformats: END -->");
                text = before + "<!-- dataformats: START -->\n" + changed + "\n<!-- dataformats: END -->" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- dataformats: START -->");
            this.getLog().warn((CharSequence)"\t<!-- dataformats: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguages(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "<!-- languages: START -->", "<!-- languages: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "<!-- languages: START -->");
                String after = StringHelper.after(text, "<!-- languages: END -->");
                text = before + "<!-- languages: START -->\n" + changed + "\n<!-- languages: END -->" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- languages: START -->");
            this.getLog().warn((CharSequence)"\t<!-- languages: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private static String link(ComponentModel model) {
        return "[" + model.getTitle() + "](" + model.getScheme() + "-component.adoc)";
    }

    private static String link(OtherModel model) {
        return "[" + model.getTitle() + "](" + model.getName() + ".adoc)";
    }

    private static String link(DataFormatModel model) {
        String name = PrepareUserGuideMojo.asDataFormatName(model.getName());
        return "[" + model.getTitle() + "](" + name + "-dataformat.adoc)";
    }

    private static String link(LanguageModel model) {
        return "[" + model.getTitle() + "](" + model.getName() + "-language.adoc)";
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }

    private ComponentModel generateComponentModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setAlternativeSchemes(JSonSchemaHelper.getSafeValue("alternativeSchemes", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return component;
    }

    private OtherModel generateOtherModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("other", json, false);
        OtherModel other = new OtherModel();
        other.setName(JSonSchemaHelper.getSafeValue("name", rows));
        other.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        other.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        other.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        other.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        other.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        other.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        other.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        other.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        other.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return other;
    }

    private DataFormatModel generateDataFormatModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel();
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return dataFormat;
    }

    private LanguageModel generateLanguageModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel();
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        return language;
    }

    private static class LanguageComparator
    implements Comparator<LanguageModel> {
        private LanguageComparator() {
        }

        @Override
        public int compare(LanguageModel o1, LanguageModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class DataFormatComparator
    implements Comparator<DataFormatModel> {
        private DataFormatComparator() {
        }

        @Override
        public int compare(DataFormatModel o1, DataFormatModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class OtherComparator
    implements Comparator<OtherModel> {
        private OtherComparator() {
        }

        @Override
        public int compare(OtherModel o1, OtherModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class ComponentComparator
    implements Comparator<ComponentModel> {
        private ComponentComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }
}

