/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;

@Mojo(name="prepare-catalog", threadSafe=true)
public class PrepareCatalogMojo
extends AbstractMojo {
    public static final int BUFFER_SIZE = 131072;
    private static final String[] EXCLUDE_DOC_FILES = new String[]{"camel-core-osgi", "camel-core-xml", "camel-http-common", "camel-jetty-common"};
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\\"label\\\":\\s\\\"([\\w,]+)\\\"");
    private static final int UNUSED_LABELS_WARN = 15;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="true")
    protected Boolean validate;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/components")
    protected File componentsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/dataformats")
    protected File dataFormatsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/languages")
    protected File languagesOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/others")
    protected File othersOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/docs")
    protected File documentsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/models")
    protected File modelsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/archetypes")
    protected File archetypesOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/schemas")
    protected File schemasOutDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core")
    protected File coreDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-spring")
    protected File springDir;
    @Parameter(defaultValue="${project.build.directory}/../../../archetypes")
    protected File archetypesDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-spring/target/schema")
    protected File springSchemaDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-blueprint/target/schema")
    protected File blueprintSchemaDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeModel();
        Set<String> components = this.executeComponents();
        Set<String> dataformats = this.executeDataFormats();
        Set<String> languages = this.executeLanguages();
        Set<String> others = this.executeOthers();
        this.executeDocuments(components, dataformats, languages, others);
        this.executeArchetypes();
        this.executeXmlSchemas();
    }

    /*
     * WARNING - void declaration
     */
    protected void executeModel() throws MojoExecutionException, MojoFailureException {
        String name;
        File target;
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"Copying all Camel model json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> missingLabels = new TreeSet<File>();
        TreeSet<File> missingJavaDoc = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            target = new File(this.coreDir, "target/classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        if (this.springDir != null && this.springDir.isDirectory()) {
            target = new File(this.springDir, "target/classes/org/apache/camel/spring");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
            File target2 = new File(this.springDir, "target/classes/org/apache/camel/core/xml");
            PackageHelper.findJsonFiles(target2, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " model json files"));
        this.modelsOutDir.mkdirs();
        boolean warnDups = this.modelsOutDir.list() == null || this.modelsOutDir.list().length == 0;
        for (File file : jsonFiles) {
            File to = new File(this.modelsOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateJsonFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate model name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                if (text.contains("\"label\": \"\"")) {
                    missingLabels.add(file);
                } else {
                    String name2 = PrepareCatalogMojo.asComponentName(file);
                    Matcher matcher = LABEL_PATTERN.matcher(text);
                    if (matcher.find()) {
                        String[] labels;
                        String string = matcher.group(1);
                        for (String s : labels = string.split(",")) {
                            usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name2);
                        }
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", text, true);
                for (Map map : rows) {
                    String doc;
                    name = (String)map.get("name");
                    if ("outputs".equals(name) || "transforms".equals(name) || (doc = (String)map.get("description")) != null && !doc.isEmpty()) continue;
                    missingJavaDoc.add(file);
                }
            }
            catch (IOException text) {}
        }
        File all = new File(this.modelsOutDir, "../models.properties");
        try {
            void var13_24;
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.modelsOutDir.list();
            ArrayList<String> models = new ArrayList<String>();
            String[] stringArray = names;
            int matcher = stringArray.length;
            boolean bl = false;
            while (var13_24 < matcher) {
                name = stringArray[var13_24];
                if (name.endsWith(".json")) {
                    String modelName = name.substring(0, name.length() - 5);
                    models.add(modelName);
                }
                ++var13_24;
            }
            Collections.sort(models);
            for (String name3 : models) {
                fos.write(name3.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printModelsReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels, missingJavaDoc);
    }

    /*
     * WARNING - void declaration
     */
    protected Set<String> executeComponents() throws MojoExecutionException, MojoFailureException {
        File[] components;
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> componentFiles = new TreeSet<File>();
        TreeSet<File> missingComponents = new TreeSet<File>();
        TreeMap<String, Set<String>> usedComponentLabels = new TreeMap<String, Set<String>>();
        TreeSet<String> usedOptionLabels = new TreeSet<String>();
        TreeSet<String> unlabeledOptions = new TreeSet<String>();
        TreeSet<File> missingFirstVersions = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (components = this.componentsDir.listFiles()) != null) {
            for (File dir : components) {
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                if ("camel-as2".equals(dir.getName())) {
                    target = new File(dir, "camel-as2-component/target/classes");
                } else if ("camel-salesforce".equals(dir.getName())) {
                    target = new File(dir, "camel-salesforce-component/target/classes");
                } else if ("camel-linkedin".equals(dir.getName())) {
                    target = new File(dir, "camel-linkedin-component/target/classes");
                } else if ("camel-olingo2".equals(dir.getName())) {
                    target = new File(dir, "camel-olingo2-component/target/classes");
                } else if ("camel-olingo4".equals(dir.getName())) {
                    target = new File(dir, "camel-olingo4-component/target/classes");
                } else if ("camel-box".equals(dir.getName())) {
                    target = new File(dir, "camel-box-component/target/classes");
                } else if ("camel-servicenow".equals(dir.getName())) {
                    target = new File(dir, "camel-servicenow-component/target/classes");
                } else if ("camel-fhir".equals(dir.getName())) {
                    target = new File(dir, "camel-fhir-component/target/classes");
                } else {
                    boolean active;
                    File src = new File(dir, "src");
                    boolean bl = active = src.isDirectory() && src.exists();
                    if (!active) continue;
                }
                int before = componentFiles.size();
                int before2 = jsonFiles.size();
                this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
                int after = componentFiles.size();
                int after2 = jsonFiles.size();
                if (before == after || before2 != after2) continue;
                missingComponents.add(dir);
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            int before = componentFiles.size();
            int before2 = jsonFiles.size();
            this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
            int after = componentFiles.size();
            int after2 = jsonFiles.size();
            if (before != after && before2 == after2) {
                missingComponents.add(this.coreDir);
            }
        }
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        this.componentsOutDir.mkdirs();
        boolean warnDups = this.componentsOutDir.list() == null || this.componentsOutDir.list().length == 0;
        HashSet<String> alternativeSchemes = new HashSet<String>();
        for (File file : jsonFiles) {
            File to = new File(this.componentsOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateJsonFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate component name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                void var19_39;
                String text = PackageHelper.loadText(new FileInputStream(file));
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (matcher.find()) {
                    String[] labels;
                    String label = matcher.group(1);
                    for (String string : labels = label.split(",")) {
                        TreeSet<String> components2 = (TreeSet<String>)usedComponentLabels.get(string);
                        if (components2 == null) {
                            components2 = new TreeSet<String>();
                            usedComponentLabels.put(string, components2);
                        }
                        components2.add(name);
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("componentProperties", text, true);
                for (Map<String, String> map : rows) {
                    String[] parts2;
                    String string = map.get("label");
                    if (string == null || string.isEmpty()) continue;
                    for (String part : parts2 = string.split(",")) {
                        usedOptionLabels.add(part);
                    }
                }
                int unused = 0;
                rows = JSonSchemaHelper.parseJsonSchema("properties", text, true);
                for (Map<String, String> map : rows) {
                    String label = map.get("label");
                    if (label != null && !label.isEmpty()) {
                        String[] stringArray;
                        for (String part : stringArray = label.split(",")) {
                            usedOptionLabels.add(part);
                        }
                        continue;
                    }
                    ++unused;
                }
                if (unused >= 15) {
                    unlabeledOptions.add(name);
                }
                rows = JSonSchemaHelper.parseJsonSchema("component", text, false);
                for (Map<String, String> map : rows) {
                    String alternativeScheme = map.get("alternativeSchemes");
                    if (alternativeScheme == null || alternativeScheme.isEmpty()) continue;
                    String[] stringArray = alternativeScheme.split(",");
                    for (int i = 1; i < stringArray.length; ++i) {
                        String part = stringArray[i];
                        alternativeSchemes.add(part);
                    }
                }
                Object var19_46 = null;
                for (Map<String, String> row5 : rows) {
                    if (row5.get("firstVersion") == null) continue;
                    String string = row5.get("firstVersion");
                }
                if (var19_39 != null) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException text) {}
        }
        LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        File all = new File(this.componentsOutDir, "../components.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.componentsOutDir.list();
            ArrayList<String> components3 = new ArrayList<String>();
            for (String string : names) {
                if (!string.endsWith(".json")) continue;
                String string2 = string.substring(0, string.length() - 5);
                components3.add(string2);
            }
            Collections.sort(components3);
            for (String name : components3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
                componentNames.add(name);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printComponentsReport(jsonFiles, duplicateJsonFiles, missingComponents, usedComponentLabels, usedOptionLabels, unlabeledOptions, missingFirstVersions);
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        for (String componentName : componentNames) {
            if (alternativeSchemes.contains(componentName)) continue;
            answer.add(componentName);
        }
        return answer;
    }

    protected Set<String> executeDataFormats() throws MojoExecutionException, MojoFailureException {
        File[] dataFormats;
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<File> missingFirstVersions = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (dataFormats = this.componentsDir.listFiles()) != null) {
            for (File dir : dataFormats) {
                boolean active;
                if (dir.isDirectory() && "camel-fhir".equals(dir.getName())) {
                    dir = new File(dir, "camel-fhir-component");
                }
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active) continue;
                this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        this.dataFormatsOutDir.mkdirs();
        boolean warnDups = this.dataFormatsOutDir.list() == null || this.dataFormatsOutDir.list().length == 0;
        for (File file : jsonFiles) {
            File to = new File(this.dataFormatsOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateJsonFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate dataformat name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (matcher.find()) {
                    String label = matcher.group(1);
                    String[] labels = label.split(",");
                    for (String s : labels) {
                        TreeSet<String> dataFormats2 = (TreeSet<String>)usedLabels.get(s);
                        if (dataFormats2 == null) {
                            dataFormats2 = new TreeSet<String>();
                            usedLabels.put(s, dataFormats2);
                        }
                        dataFormats2.add(name);
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", text, false);
                String firstVersion = null;
                for (Map map : rows) {
                    if (map.get("firstVersion") == null) continue;
                    firstVersion = (String)map.get("firstVersion");
                }
                if (firstVersion != null) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException text) {}
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        File all = new File(this.dataFormatsOutDir, "../dataformats.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.dataFormatsOutDir.list();
            ArrayList<String> dataFormats3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String string = name.substring(0, name.length() - 5);
                dataFormats3.add(string);
            }
            Collections.sort(dataFormats3);
            for (String name : dataFormats3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
                answer.add(name);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printDataFormatsReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return answer;
    }

    protected Set<String> executeLanguages() throws MojoExecutionException, MojoFailureException {
        File[] languages;
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> languageFiles = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<File> missingFirstVersions = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (languages = this.componentsDir.listFiles()) != null) {
            for (File dir : languages) {
                boolean active;
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active) continue;
                this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        this.languagesOutDir.mkdirs();
        boolean warnDups = this.languagesOutDir.list() == null || this.languagesOutDir.list().length == 0;
        for (File file : jsonFiles) {
            File to = new File(this.languagesOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateJsonFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate language name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (matcher.find()) {
                    String label = matcher.group(1);
                    String[] labels = label.split(",");
                    for (String s : labels) {
                        TreeSet<String> languages2 = (TreeSet<String>)usedLabels.get(s);
                        if (languages2 == null) {
                            languages2 = new TreeSet<String>();
                            usedLabels.put(s, languages2);
                        }
                        languages2.add(name);
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", text, false);
                String firstVersion = null;
                for (Map map : rows) {
                    if (map.get("firstVersion") == null) continue;
                    firstVersion = (String)map.get("firstVersion");
                }
                if (firstVersion != null) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException text) {}
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        File all = new File(this.languagesOutDir, "../languages.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.languagesOutDir.list();
            ArrayList<String> languages3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String string = name.substring(0, name.length() - 5);
                languages3.add(string);
            }
            Collections.sort(languages3);
            for (String name : languages3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
                answer.add(name);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printLanguagesReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return answer;
    }

    private Set<String> executeOthers() throws MojoFailureException {
        File[] others;
        this.getLog().info((CharSequence)"Copying all Camel other json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> otherFiles = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<File> missingFirstVersions = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (others = this.componentsDir.listFiles()) != null) {
            for (File dir : others) {
                boolean active;
                File target;
                boolean special2;
                boolean special = "camel-core-osgi".equals(dir.getName()) || "camel-core-xml".equals(dir.getName()) || "camel-box".equals(dir.getName()) || "camel-http-common".equals(dir.getName()) || "camel-jetty-common".equals(dir.getName());
                boolean bl = special2 = "camel-as2".equals(dir.getName()) || "camel-linkedin".equals(dir.getName()) || "camel-olingo2".equals(dir.getName()) || "camel-olingo4".equals(dir.getName()) || "camel-servicenow".equals(dir.getName()) || "camel-salesforce".equals(dir.getName()) || "camel-fhir".equals(dir.getName());
                if (special || special2 || !dir.isDirectory() || "target".equals(dir.getName()) || !(target = new File(dir, "target/classes")).exists()) continue;
                File src = new File(dir, "src");
                boolean bl2 = active = src.isDirectory() && src.exists();
                if (!active) continue;
                this.findOtherFilesRecursive(target, jsonFiles, otherFiles, new CamelOthersFileFilter());
            }
        }
        this.getLog().info((CharSequence)("Found " + otherFiles.size() + " other.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " other json files"));
        this.othersOutDir.mkdirs();
        boolean warnDups = this.othersOutDir.list() == null || this.othersOutDir.list().length == 0;
        for (File file : jsonFiles) {
            File to = new File(this.othersOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateJsonFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate other name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (matcher.find()) {
                    String label = matcher.group(1);
                    String[] labels = label.split(",");
                    for (String s : labels) {
                        TreeSet<String> others2 = (TreeSet<String>)usedLabels.get(s);
                        if (others2 == null) {
                            others2 = new TreeSet<String>();
                            usedLabels.put(s, others2);
                        }
                        others2.add(name);
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("other", text, false);
                String firstVersion = null;
                for (Map map : rows) {
                    if (map.get("firstVersion") == null) continue;
                    firstVersion = (String)map.get("firstVersion");
                }
                if (firstVersion != null) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException text) {}
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        File all = new File(this.othersOutDir, "../others.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.othersOutDir.list();
            ArrayList<String> others3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String string = name.substring(0, name.length() - 5);
                others3.add(string);
            }
            Collections.sort(others3);
            for (String name : others3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
                answer.add(name);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printOthersReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return answer;
    }

    protected void executeArchetypes() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Copying Archetype Catalog");
        File file = new File(this.archetypesDir, "target/classes/archetype-catalog.xml");
        this.archetypesOutDir.mkdirs();
        if (file.exists() && file.isFile()) {
            File to = new File(this.archetypesOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    protected void executeXmlSchemas() throws MojoExecutionException, MojoFailureException {
        File to;
        this.getLog().info((CharSequence)"Copying Spring/Blueprint XML schemas");
        this.schemasOutDir.mkdirs();
        File file = new File(this.springSchemaDir, "camel-spring.xsd");
        if (file.exists() && file.isFile()) {
            to = new File(this.schemasOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
        if ((file = new File(this.blueprintSchemaDir, "camel-blueprint.xsd")).exists() && file.isFile()) {
            to = new File(this.schemasOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    protected void executeDocuments(Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) throws MojoExecutionException, MojoFailureException {
        File[] componentFiles;
        this.getLog().info((CharSequence)"Copying all Camel documents (ascii docs)");
        TreeSet<File> adocFiles = new TreeSet<File>();
        TreeSet<File> missingAdocFiles = new TreeSet<File>();
        TreeSet<File> duplicateAdocFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (componentFiles = this.componentsDir.listFiles()) != null) {
            for (File dir : componentFiles) {
                if (!dir.isDirectory() || "target".equals(dir.getName()) || dir.getName().startsWith(".") || PrepareCatalogMojo.excludeDocumentDir(dir.getName())) continue;
                File target = new File(dir, "src/main/docs");
                if ("camel-as2".equals(dir.getName())) {
                    target = new File(dir, "camel-as2-component/src/main/docs");
                } else if ("camel-salesforce".equals(dir.getName())) {
                    target = new File(dir, "camel-salesforce-component/src/main/docs");
                } else if ("camel-linkedin".equals(dir.getName())) {
                    target = new File(dir, "camel-linkedin-component/src/main/docs");
                } else if ("camel-olingo2".equals(dir.getName())) {
                    target = new File(dir, "camel-olingo2-component/src/main/docs");
                } else if ("camel-olingo4".equals(dir.getName())) {
                    target = new File(dir, "camel-olingo4-component/src/main/docs");
                } else if ("camel-box".equals(dir.getName())) {
                    target = new File(dir, "camel-box-component/src/main/docs");
                } else if ("camel-servicenow".equals(dir.getName())) {
                    target = new File(dir, "camel-servicenow-component/src/main/docs");
                } else if ("camel-fhir".equals(dir.getName())) {
                    target = new File(dir, "camel-fhir-component/src/main/docs");
                } else {
                    boolean active;
                    File src = new File(dir, "src");
                    boolean bl = active = src.isDirectory() && src.exists();
                    if (!active) continue;
                }
                int before = adocFiles.size();
                this.findAsciiDocFilesRecursive(target, adocFiles, new CamelAsciiDocFileFilter());
                int after = adocFiles.size();
                if (before != after) continue;
                missingAdocFiles.add(dir);
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "src/main/docs");
            this.findAsciiDocFilesRecursive(target, adocFiles, new CamelAsciiDocFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + adocFiles.size() + " ascii document files"));
        this.documentsOutDir.mkdirs();
        boolean warnDups = this.documentsOutDir.list() == null || this.documentsOutDir.list().length == 0;
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        int converted = 0;
        for (File file : adocFiles) {
            File to = new File(this.documentsOutDir, file.getName());
            if (to.exists()) {
                if (warnDups) {
                    duplicateAdocFiles.add(to);
                    this.getLog().warn((CharSequence)("Duplicate document name detected: " + to));
                } else {
                    if (file.lastModified() < to.lastModified()) {
                        this.getLog().debug((CharSequence)("Skipping generated file: " + to));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Stale file: " + to));
                }
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            if (!file.getName().endsWith(".adoc")) continue;
            String newName = file.getName().substring(0, file.getName().length() - 5) + ".html";
            File toHtml = new File(this.documentsOutDir, newName);
            this.getLog().debug((CharSequence)("Converting ascii document to html -> " + toHtml));
            asciidoctor.convertFile(file, OptionsBuilder.options().toFile(toHtml));
            ++converted;
            try {
                List lines = FileUtils.readLines((File)toHtml);
                ArrayList<String> output = new ArrayList<String>();
                for (String line : lines) {
                    if (line.contains("% raw %") || line.contains("% endraw %")) continue;
                    output.add(line);
                }
                if (lines.size() == output.size()) continue;
                FileUtils.writeLines((File)toHtml, output, (boolean)false);
            }
            catch (IOException iOException) {}
        }
        if (converted > 0) {
            this.getLog().info((CharSequence)("Converted " + converted + " ascii documents to HTML"));
        }
        LinkedHashSet<String> docs = new LinkedHashSet<String>();
        File all = new File(this.documentsOutDir, "../docs.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.documentsOutDir.list();
            ArrayList<String> documents = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".adoc")) continue;
                String documentName = name.substring(0, name.length() - 5);
                documents.add(documentName);
            }
            Collections.sort(documents);
            for (String name : documents) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
                docs.add(name);
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printDocumentsReport(adocFiles, duplicateAdocFiles, missingAdocFiles);
        this.printMissingDocumentsReport(docs, components, dataformats, languages, others);
    }

    private void printMissingDocumentsReport(Set<String> docs, Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) {
        String name;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel missing documents report");
        this.getLog().info((CharSequence)"");
        ArrayList<String> missing = new ArrayList<String>();
        for (String component : components) {
            if (component.equals("imap") || component.equals("imaps") || component.equals("pop3") || component.equals("pop3s") || component.equals("smtp") || component.equals("smtps")) {
                component = "mail";
            } else if (component.equals("ftp") || component.equals("sftp") || component.equals("ftps")) {
                component = "ftp";
            }
            if (docs.contains(name = component + "-component") || component.equalsIgnoreCase("linkedin") || component.equalsIgnoreCase("salesforce") || component.equalsIgnoreCase("servicenow")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc component documentation  : " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String dataformat : dataformats) {
            if (dataformat.startsWith("bindy")) {
                dataformat = "bindy";
            }
            if (docs.contains(name = dataformat + "-dataformat")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc dataformat documentation  : " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String language : languages) {
            name = language + "-language";
            if (docs.contains(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc language documentation  : " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String other : others) {
            name = other;
            if (docs.contains(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc other documentation  : " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printModelsReport(Set<File> json, Set<File> duplicate, Set<File> missingLabels, Map<String, Set<String>> usedLabels, Set<File> missingJavaDoc) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel model catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tModels found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate models detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (File file : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing javadoc on models: " + missingJavaDoc.size()));
            for (File file : missingJavaDoc) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printComponentsReport(Set<File> json, Set<File> duplicate, Set<File> missing, Map<String, Set<String>> usedComponentLabels, Set<String> usedOptionsLabels, Set<String> unusedLabels, Set<File> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel component catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tComponents found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate components detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedComponentLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed component labels: " + usedComponentLabels.size()));
            for (Map.Entry entry : usedComponentLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!usedOptionsLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed component/endpoint options labels: " + usedOptionsLabels.size()));
            for (String string : usedOptionsLabels) {
                this.getLog().info((CharSequence)("\t\t\t" + string));
            }
        }
        if (!unusedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tComponent with more than 15 unlabelled options: " + unusedLabels.size()));
            for (String string : unusedLabels) {
                this.getLog().info((CharSequence)("\t\t\t" + string));
            }
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing components detected: " + missing.size()));
            for (File file : missing) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tComponents without firstVersion defined: " + missingFirstVersions.size()));
            for (File file : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printDataFormatsReport(Set<File> json, Set<File> duplicate, Map<String, Set<String>> usedLabels, Set<File> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel data format catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDataFormats found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate dataformat detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDataFormats without firstVersion defined: " + missingFirstVersions.size()));
            for (File file : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printLanguagesReport(Set<File> json, Set<File> duplicate, Map<String, Set<String>> usedLabels, Set<File> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel language catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tLanguages found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate language detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tLanguages without firstVersion defined: " + missingFirstVersions.size()));
            for (File file : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printOthersReport(Set<File> json, Set<File> duplicate, Map<String, Set<String>> usedLabels, Set<File> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel other catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tOthers found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate other detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tOthers without firstVersion defined: " + missingFirstVersions.size()));
            for (File file : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printDocumentsReport(Set<File> docs, Set<File> duplicate, Set<File> missing) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel document catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDocuments found: " + docs.size()));
        for (File file : docs) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate document detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        this.getLog().info((CharSequence)"");
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing document detected: " + missing.size()));
            for (File name : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private static String asComponentName(File file) {
        String name = file.getName();
        if (name.endsWith(".json") || name.endsWith(".adoc")) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }

    private void findComponentFilesRecursive(File dir, Set<File> found, Set<File> components, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean componentFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = componentFile = !rootDir && file.isFile() && file.getName().equals("component.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (componentFile) {
                    components.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findComponentFilesRecursive(file, found, components, filter);
            }
        }
    }

    private void findDataFormatFilesRecursive(File dir, Set<File> found, Set<File> dataFormats, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean dataFormatFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = dataFormatFile = !rootDir && file.isFile() && file.getName().equals("dataformat.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (dataFormatFile) {
                    dataFormats.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findDataFormatFilesRecursive(file, found, dataFormats, filter);
            }
        }
    }

    private void findLanguageFilesRecursive(File dir, Set<File> found, Set<File> languages, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean languageFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = languageFile = !rootDir && file.isFile() && file.getName().equals("language.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (languageFile) {
                    languages.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findLanguageFilesRecursive(file, found, languages, filter);
            }
        }
    }

    private void findOtherFilesRecursive(File dir, Set<File> found, Set<File> others, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean otherFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = otherFile = !rootDir && file.isFile() && file.getName().equals("other.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (otherFile) {
                    others.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findOtherFilesRecursive(file, found, others, filter);
            }
        }
    }

    private void findAsciiDocFilesRecursive(File dir, Set<File> found, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean adocFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean bl = adocFile = !rootDir && file.isFile() && file.getName().endsWith(".adoc");
                if (adocFile) {
                    found.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findAsciiDocFilesRecursive(file, found, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try (FileInputStream fis = new FileInputStream(from);
             FileOutputStream fos = new FileOutputStream(to);){
            try {
                in = fis.getChannel();
                out = fos.getChannel();
                long size = in.size();
                for (long position = 0L; position < size; position += in.transferTo(position, 131072L, out)) {
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static boolean excludeDocumentDir(String name) {
        for (String exclude : EXCLUDE_DOC_FILES) {
            if (!exclude.equals(name)) continue;
            return true;
        }
        return false;
    }

    private class CamelAsciiDocFileFilter
    implements FileFilter {
        private CamelAsciiDocFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".adoc");
        }
    }

    private class CamelOthersFileFilter
    implements FileFilter {
        private CamelOthersFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"other\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("other.properties");
        }
    }

    private class CamelLanguagesFileFilter
    implements FileFilter {
        private CamelLanguagesFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"language\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("language.properties");
        }
    }

    private class CamelDataFormatsFileFilter
    implements FileFilter {
        private CamelDataFormatsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"dataformat\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("dataformat.properties");
        }
    }

    private class CamelComponentsFileFilter
    implements FileFilter {
        private CamelComponentsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"component\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("component.properties");
        }
    }
}

