/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.ComponentDslMojo;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslBuilderFactoryGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslInnerBuilderGenerator;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;

public final class ComponentsBuilderFactoryGenerator {
    private static final String CLASS_NAME = "ComponentsBuilderFactory";
    private final String packageName;
    private final Set<ComponentModel> componentModels;
    private JavaClass javaClass;

    private ComponentsBuilderFactoryGenerator(Set<ComponentModel> componentModels, ClassLoader classLoader, String packageName) {
        this.componentModels = componentModels;
        this.packageName = packageName;
        this.javaClass = new JavaClass(classLoader);
        this.generateJavaClass();
    }

    public static ComponentsBuilderFactoryGenerator generateClass(Set<ComponentModel> componentModels, ClassLoader classLoader, String packageName) {
        Objects.requireNonNull(componentModels);
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(packageName);
        return new ComponentsBuilderFactoryGenerator(componentModels, classLoader, packageName);
    }

    public String printClassAsString() {
        return this.javaClass.printClass(true);
    }

    public String toString() {
        return this.printClassAsString();
    }

    public String getGeneratedClassName() {
        return CLASS_NAME;
    }

    private void generateJavaClass() {
        this.setPackage();
        this.setJavaDoc();
        this.setMainAnnotations();
        this.setBuilderFactoryClassNameAndType();
        this.setComponentsDslMethods();
    }

    private void setPackage() {
        this.javaClass.setPackage(this.packageName);
    }

    private void setJavaDoc() {
        String doc = "Component entry DSL builder. You can build a component like this: ComponentBuilderFactory.kafka().setBrokers(\"{{host:port}}\").build()\n\nGenerated by camel build tools - do NOT edit this file!";
        this.javaClass.getJavaDoc().setText("Component entry DSL builder. You can build a component like this: ComponentBuilderFactory.kafka().setBrokers(\"{{host:port}}\").build()\n\nGenerated by camel build tools - do NOT edit this file!");
    }

    private void setMainAnnotations() {
        this.javaClass.addAnnotation(Generated.class).setStringValue("value", ComponentDslMojo.class.getName());
    }

    private void setBuilderFactoryClassNameAndType() {
        this.javaClass.setClass(false).setPublic().setName(this.getGeneratedClassName());
    }

    private void setComponentsDslMethods() {
        this.componentModels.forEach(componentModel -> {
            String returnType = this.packageName + ".dsl." + ComponentDslBuilderFactoryGenerator.getExpectedGeneratedClassName(componentModel) + "." + ComponentDslInnerBuilderGenerator.getExpectedGeneratedInterfaceName(componentModel);
            Method componentEntryMethod = this.javaClass.addMethod();
            componentEntryMethod.setStatic().setReturnType(returnType).setName(DslHelper.toCamelCaseLower(componentModel.getScheme())).setBody(String.format("return %s.dsl.%s.%s();", this.packageName, ComponentDslBuilderFactoryGenerator.getExpectedGeneratedClassName(componentModel), DslHelper.toCamelCaseLower(componentModel.getScheme())));
            if (componentModel.isDeprecated()) {
                componentEntryMethod.addAnnotation(Deprecated.class);
            }
            componentEntryMethod.getJavaDoc().setFullText(DslHelper.getMainDescriptionWithoutPathOptions(componentModel));
        });
    }
}

