/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.StringJoiner;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;

public final class EndpointUriFactoryGenerator {
    private EndpointUriFactoryGenerator() {
    }

    public static void generateEndpointUriFactory(String pn, String cn, String en, String pfqn, String psn, ComponentModel model, Writer w) throws IOException {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import java.net.URISyntaxException;\n");
        w.write("import java.util.Collections;\n");
        w.write("import java.util.HashMap;\n");
        w.write("import java.util.HashSet;\n");
        w.write("import java.util.Map;\n");
        w.write("import java.util.Set;\n");
        w.write("\n");
        w.write("import org.apache.camel.spi.EndpointUriFactory;\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("public class " + cn + " extends " + psn + " implements EndpointUriFactory {\n");
        w.write("\n");
        w.write("    private static final String BASE = \"" + EndpointUriFactoryGenerator.baseSyntax(model) + "\";\n");
        String alternative = EndpointUriFactoryGenerator.alternativeSchemes(model);
        if (alternative != null) {
            w.write("    private static final String[] SCHEMES = " + alternative + ";\n");
        }
        w.write("\n");
        w.write("    private static final Set<String> PROPERTY_NAMES;\n");
        w.write("    private static final Set<String> SECRET_PROPERTY_NAMES;\n");
        w.write("    static {\n");
        w.write(EndpointUriFactoryGenerator.generatePropertyNames(model));
        w.write(EndpointUriFactoryGenerator.generateSecretPropertyNames(model));
        w.write("    }\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public boolean isEnabled(String scheme) {\n");
        if (alternative == null) {
            w.write("        return \"" + model.getScheme() + "\".equals(scheme);\n");
        } else {
            w.write("        for (String s : SCHEMES) {\n");
            w.write("            if (s.equals(scheme)) {\n");
            w.write("                return true;\n");
            w.write("            }\n");
            w.write("        }\n");
            w.write("        return false;\n");
        }
        w.write("    }\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {\n");
        w.write("        String syntax = scheme + BASE;\n");
        w.write("        String uri = syntax;\n");
        w.write("\n");
        w.write("        Map<String, Object> copy = new HashMap<>(properties);\n");
        w.write("\n");
        for (BaseOptionModel option : model.getEndpointPathOptions()) {
            w.write("        uri = buildPathParameter(syntax, uri, \"" + option.getName() + "\", " + EndpointUriFactoryGenerator.defaultValue(option) + ", " + option.isRequired() + ", copy);\n");
        }
        w.write("        uri = buildQueryParameters(uri, copy, encode);\n");
        w.write("        return uri;\n");
        w.write("    }\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public Set<String> propertyNames() {\n");
        w.write("        return PROPERTY_NAMES;\n");
        w.write("    }\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public Set<String> secretPropertyNames() {\n");
        w.write("        return SECRET_PROPERTY_NAMES;\n");
        w.write("    }\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public boolean isLenientProperties() {\n");
        w.write("        return " + model.isLenientProperties() + ";\n");
        w.write("    }\n");
        w.write("}\n");
        w.write("\n");
    }

    private static String generatePropertyNames(ComponentModel model) {
        HashSet properties = new HashSet();
        model.getEndpointOptions().stream().map(BaseOptionModel::getName).forEach(properties::add);
        model.getApiOptions().stream().flatMap(a -> a.getMethods().stream()).flatMap(m -> m.getOptions().stream()).map(BaseOptionModel::getName).forEach(properties::add);
        if (properties.isEmpty()) {
            return "        PROPERTY_NAMES = Collections.emptySet();\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("        Set<String> props = new HashSet<>(").append(properties.size()).append(");\n");
        for (String property : properties) {
            sb.append("        props.add(\"").append(property).append("\");\n");
        }
        sb.append("        PROPERTY_NAMES = Collections.unmodifiableSet(props);\n");
        return sb.toString();
    }

    private static String generateSecretPropertyNames(ComponentModel model) {
        HashSet properties = new HashSet();
        model.getEndpointOptions().stream().filter(BaseOptionModel::isSecret).map(BaseOptionModel::getName).forEach(properties::add);
        model.getApiOptions().stream().flatMap(a -> a.getMethods().stream()).flatMap(m -> m.getOptions().stream()).filter(BaseOptionModel::isSecret).map(BaseOptionModel::getName).forEach(properties::add);
        if (properties.isEmpty()) {
            return "        SECRET_PROPERTY_NAMES = Collections.emptySet();\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("        Set<String> secretProps = new HashSet<>(").append(properties.size()).append(");\n");
        for (String property : properties) {
            sb.append("        secretProps.add(\"").append(property).append("\");\n");
        }
        sb.append("        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);\n");
        return sb.toString();
    }

    private static String alternativeSchemes(ComponentModel model) {
        StringBuilder sb = new StringBuilder();
        if (model.getAlternativeSchemes() != null) {
            sb.append("new String[]{");
            String[] alts = model.getAlternativeSchemes().split(",");
            StringJoiner sj = new StringJoiner(", ");
            for (String alt : alts) {
                sj.add("\"" + alt + "\"");
            }
            sb.append(sj.toString());
            sb.append("}");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static String baseSyntax(ComponentModel model) {
        String base = model.getSyntax();
        base = base.replaceFirst(model.getScheme(), "");
        return base;
    }

    private static Object defaultValue(BaseOptionModel option) {
        Object obj = option.getDefaultValue();
        if (obj instanceof String) {
            return "\"" + obj + "\"";
        }
        return obj;
    }
}

