/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public abstract class ModelWriterGeneratorMojo
extends AbstractGeneratorMojo {
    public static final String MODEL_PACKAGE = "org.apache.camel.model";
    private final Map<Class<?>, List<Property>> properties = new ConcurrentHashMap();
    private final Map<Class<?>, List<Member>> members = new ConcurrentHashMap();
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;

    private static Type type(Member member) {
        return member instanceof Method ? (member.getName().startsWith("set") ? ((Method)member).getGenericParameterTypes()[0] : ((Method)member).getGenericReturnType()) : ((Field)member).getGenericType();
    }

    String getModelPackage() {
        return MODEL_PACKAGE;
    }

    abstract String getWriterPackage();

    protected String generateWriter() throws MojoExecutionException {
        Index index;
        DynamicClassLoader classLoader;
        try {
            classLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        Class<?> routesDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.RoutesDefinition");
        String resName = routesDefinitionClass.getName().replace('.', '/') + ".class";
        String url = classLoader.getResource(resName).toExternalForm().replace(resName, "META-INF/jandex.idx");
        try (InputStream is = new URL(url).openStream();){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        List<String> names = Stream.of(XmlRootElement.class, XmlEnum.class, XmlType.class).map(c -> index.getAnnotations(DotName.createSimple((String)c.getName()))).flatMap(Collection::stream).map(ai -> ai.target().asClass().name().toString()).sorted().distinct().toList();
        List<Class> model = names.stream().filter(n -> !n.equals("org.apache.camel.model.WhenSkipSendToEndpointDefinition")).map(name -> this.loadClass(classLoader, (String)name)).flatMap(this::references).flatMap(this::fieldReferences).distinct().sorted(Comparator.comparing(Class::getName)).toList();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("package", this.getWriterPackage());
        ctx.put("model", model);
        ctx.put("mojo", (Object)this);
        String parser = this.velocity("velocity/model-writer.vm", ctx);
        return parser;
    }

    protected Class<?> loadClass(ClassLoader loader, String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class " + name, e);
        }
    }

    public TreeSet<Class<?>> newClassTreeSet() {
        return new TreeSet(Comparator.comparing(Class::getName));
    }

    public Stream<Class<?>> getClassAndSuper(Class<?> clazz) {
        return clazz != Object.class && clazz != null ? Stream.concat(Stream.of(clazz), this.getClassAndSuper(clazz.getSuperclass())) : Stream.empty();
    }

    public String getGenericSimpleName(Class<?> clazz) {
        Object name = clazz.getSimpleName();
        if (clazz.getTypeParameters().length > 0) {
            name = (String)name + Stream.of(clazz.getTypeParameters()).map(t -> "?").collect(Collectors.joining(", ", "<", ">"));
        }
        return name;
    }

    public boolean isReferenced(Class<?> clazz, List<Class<?>> model) {
        return model.stream().flatMap(this::getProperties).anyMatch(p -> {
            GenericType t = p.getGenericType();
            Class cl = t.getRawClass() == List.class ? t.getActualTypeArgument(0).getRawClass() : t.getRawClass();
            return cl == clazz;
        });
    }

    public XmlRootElement getXmlRootElement(Class<?> clazz) {
        return clazz.getAnnotation(XmlRootElement.class);
    }

    public XmlEnum getXmlEnum(Class<?> clazz) {
        return clazz.getAnnotation(XmlEnum.class);
    }

    public String lowercase(String fn) {
        return fn.substring(0, 1).toLowerCase() + fn.substring(1);
    }

    public Stream<Property> getAttributes(Class<?> clazz) {
        return this.getProperties(clazz).filter(Property::isAttribute);
    }

    public Stream<Property> getElements(Class<?> clazz) {
        return this.getProperties(clazz).filter(Property::isElement).sorted(Comparator.comparing(p -> "outputs".equals(p.name)));
    }

    public Stream<Property> getValues(Class<?> clazz) {
        return this.getProperties(clazz).filter(Property::isValue);
    }

    public Stream<Property> getValues(Stream<Class<?>> classStream) {
        return this.getProperties(classStream).filter(Property::isValue);
    }

    public Stream<Property> getProperties(Class<?> clazz) {
        return this.properties.computeIfAbsent(clazz, this::doGetProperties).stream();
    }

    public Stream<Property> getProperties(Stream<Class<?>> classStream) {
        return classStream.flatMap(this::getProperties);
    }

    private List<Property> doGetProperties(Class<?> clazz) {
        String[] propOrder;
        List allMembers = this.getClassAndSuper(clazz).flatMap(cl -> this.getMembers(clazz).stream()).toList();
        Stream<Property> properties = allMembers.stream().filter(this.accessible(clazz)).collect(Collectors.groupingBy(this::propname)).entrySet().stream().map(l -> {
            List members = (List)l.getValue();
            if (!members.stream().allMatch(this::isNotTransient)) {
                return null;
            }
            String name = (String)l.getKey();
            Type type = ModelWriterGeneratorMojo.type((Member)members.get(0));
            Member field = members.stream().filter(this::isField).findFirst().or(() -> allMembers.stream().filter(m -> this.isField((Member)m) && Objects.equals(this.propname((Member)m), name) && Objects.equals(ModelWriterGeneratorMojo.type(m), type)).findFirst()).orElse(null);
            Member getter = members.stream().filter(this::isGetter).findFirst().or(() -> allMembers.stream().filter(m -> this.isGetter((Member)m) && Objects.equals(this.propname((Member)m), name) && Objects.equals(ModelWriterGeneratorMojo.type(m), type)).findFirst()).orElse(null);
            Member setter = members.stream().filter(this::isSetter).findFirst().or(() -> allMembers.stream().filter(m -> this.isSetter((Member)m) && Objects.equals(this.propname((Member)m), name) && Objects.equals(ModelWriterGeneratorMojo.type(m), type)).findFirst()).orElse(null);
            if (getter != null && setter != null) {
                return new Property(field, getter, setter, name, type);
            }
            if (field != null && this.isXmlBindAnnotated(field)) {
                this.getLog().warn((CharSequence)("Unsupported annotated field: " + field));
            }
            if (getter != null && this.isXmlBindAnnotated(getter)) {
                this.getLog().warn((CharSequence)("Unsupported annotated getter: " + getter));
            }
            if (setter != null && this.isXmlBindAnnotated(setter)) {
                this.getLog().warn((CharSequence)("Unsupported annotated setter: " + setter));
            }
            return null;
        }).filter(Objects::nonNull);
        XmlType xmlType = clazz.getAnnotation(XmlType.class);
        if (xmlType != null && (propOrder = xmlType.propOrder()) != null && propOrder.length > 0) {
            List<String> list = Arrays.stream(propOrder).map(o -> o.equals("whenClauses") ? "when" : o).toList();
            properties = properties.sorted(Comparator.comparing(p -> Arrays.binarySearch(list.toArray(), p.getName())));
        }
        return properties.toList();
    }

    private List<Member> getMembers(Class<?> clazz) {
        return this.members.computeIfAbsent(clazz, cl -> Stream.concat(Arrays.stream(cl.getDeclaredMethods()).filter(m -> this.isSetter((Member)m) || this.isGetter((Member)m)).filter(m -> !m.isSynthetic()), Arrays.stream(cl.getDeclaredFields())).toList());
    }

    private Predicate<Member> accessible(Class<?> clazz) {
        XmlAccessType accessType = clazz.getAnnotation(XmlAccessorType.class) != null ? clazz.getAnnotation(XmlAccessorType.class).value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType == XmlAccessType.PROPERTY) {
            return m -> m.getDeclaringClass() == clazz && this.isSetter((Member)m) || this.isGetter((Member)m) || this.isField((Member)m) && this.isXmlBindAnnotated((Member)m);
        }
        if (accessType == XmlAccessType.FIELD) {
            return m -> m.getDeclaringClass() == clazz && ((this.isSetter((Member)m) || this.isGetter((Member)m)) && this.isXmlBindAnnotated((Member)m) || this.isField((Member)m) && !Modifier.isStatic(m.getModifiers()) && !Modifier.isTransient(m.getModifiers()));
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return m -> m.getDeclaringClass() == clazz && (Modifier.isPublic(m.getModifiers()) || this.isXmlBindAnnotated((Member)m));
        }
        return m -> m.getDeclaringClass() == clazz && this.isXmlBindAnnotated((Member)m);
    }

    private boolean isXmlBindAnnotated(Member m) {
        return Stream.of(((AnnotatedElement)((Object)m)).getAnnotations()).anyMatch(a -> a.getClass().getAnnotatedInterfaces()[0].getType().getTypeName().startsWith("jakarta.xml.bind.annotation."));
    }

    private boolean isField(Member member) {
        return member instanceof Field;
    }

    private boolean isSetter(Member member) {
        Method m;
        return member instanceof Method && !Modifier.isStatic((m = (Method)member).getModifiers()) && m.getName().startsWith("set") && m.getName().length() > 3 && m.getParameterCount() == 1 && m.getReturnType() == Void.TYPE;
    }

    private boolean isGetter(Member member) {
        Method m;
        return member instanceof Method && !Modifier.isStatic((m = (Method)member).getModifiers()) && m.getParameterCount() == 0 && (m.getName().startsWith("get") && m.getName().length() > 3 || m.getName().startsWith("is") && m.getName().length() > 2 && (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class));
    }

    private String propname(Member member) {
        String name = member.getName();
        if (member instanceof Method) {
            if (name.startsWith("is") && name.length() > 2) {
                return this.lowercase(name.substring(2));
            }
            if ((name.startsWith("get") || name.startsWith("set")) && name.length() > 3) {
                return this.lowercase(name.substring(3));
            }
        } else if (member instanceof Field) {
            return name;
        }
        throw new IllegalArgumentException("Unable to determine property name for: " + member);
    }

    private boolean isNotTransient(Member member) {
        return ((AnnotatedElement)((Object)member)).getAnnotation(XmlTransient.class) == null;
    }

    private Stream<Class<?>> references(Class<?> clazz) {
        ArrayList allClasses = new ArrayList();
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            allClasses.add(cl);
        }
        return allClasses.stream();
    }

    private Stream<Class<?>> fieldReferences(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), this.getProperties(clazz).map(f -> {
            if (f.getAnnotation(XmlJavaTypeAdapter.class) != null) {
                Class cl = f.getAnnotation(XmlJavaTypeAdapter.class).value();
                while (cl.getSuperclass() != XmlAdapter.class) {
                    cl = cl.getSuperclass();
                }
                return ((ParameterizedType)cl.getGenericSuperclass()).getActualTypeArguments()[0];
            }
            return f.getType();
        }).map(t -> {
            GenericType gt = new GenericType(t);
            GenericType ac = gt.getRawClass() == List.class ? gt.getActualTypeArgument(0) : gt;
            return ac.getRawClass();
        }).filter(c -> c.getName().startsWith("org.apache.camel.")));
    }

    public static class Property {
        private final Member field;
        private final Member getter;
        private final Member setter;
        private final String name;
        private final Type type;

        public Property(Member field, Member getter, Member setter, String name, Type type) {
            this.field = field;
            this.getter = getter;
            this.setter = setter;
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "Property{name='" + this.name + "', type=" + this.type + ", field=" + this.field + ", getter=" + this.getter + ", setter=" + this.setter + "}";
        }

        private Stream<Member> members() {
            return Stream.of(this.field, this.getter, this.setter).filter(Objects::nonNull);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public GenericType getGenericType() {
            return new GenericType(this.type);
        }

        public String getGetter() {
            return Optional.ofNullable(this.getter).orElseThrow(() -> new IllegalArgumentException("No getter for property defined by " + this.members().toList())).getName();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)this.annotations().filter(annotationClass::isInstance).findFirst().orElse(null));
        }

        public <T extends Annotation> boolean hasAnnotation(Class<T> annotationClass) {
            return this.getAnnotation(annotationClass) != null;
        }

        private Stream<? extends Annotation> annotations() {
            return this.members().flatMap(m -> Stream.of(((AnnotatedElement)((Object)m)).getAnnotations()));
        }

        public boolean isAttribute() {
            return this.hasAnnotation(XmlAttribute.class);
        }

        public boolean isAnyAttribute() {
            return this.hasAnnotation(XmlAnyAttribute.class);
        }

        public boolean isValue() {
            return this.hasAnnotation(XmlValue.class);
        }

        public boolean isElement() {
            return !this.isAttribute() && !this.isAnyAttribute() && !this.isValue();
        }

        public boolean isElementRefs() {
            return this.hasAnnotation(XmlElementRefs.class);
        }

        public boolean isElementRef() {
            return this.hasAnnotation(XmlElementRef.class);
        }

        public XmlElementRefs getXmlElementRefs() {
            return this.getAnnotation(XmlElementRefs.class);
        }

        public XmlElementRef getXmlElementRef() {
            return this.getAnnotation(XmlElementRef.class);
        }

        public XmlElements getXmlElements() {
            return this.getAnnotation(XmlElements.class);
        }

        public XmlElement getXmlElement() {
            return this.getAnnotation(XmlElement.class);
        }

        public XmlAnyElement getXmlAnyElement() {
            return this.getAnnotation(XmlAnyElement.class);
        }

        public XmlRootElement getXmlRootElement() {
            return this.getAnnotation(XmlRootElement.class);
        }

        public XmlElementWrapper getXmlElementWrapper() {
            return this.getAnnotation(XmlElementWrapper.class);
        }

        public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
            return this.getAnnotation(XmlJavaTypeAdapter.class);
        }

        public String getAttributeName() {
            String an = this.getAnnotation(XmlAttribute.class).name();
            if ("##default".equals(an)) {
                an = this.getName();
            }
            return an;
        }
    }
}

