/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

@Mojo(name="generate-jaxb-list", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class PackageJaxbMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/META-INF/jandex.idx")
    protected File index;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File jaxbIndexOutDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.index == null) {
            this.index = new File(this.project.getBuild().getDirectory(), "META-INF/jandex.idx");
        }
        if (this.jaxbIndexOutDir == null) {
            this.jaxbIndexOutDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(this.project.getBuild().getOutputDirectory());
        this.processClasses(this.createIndex(locations));
        Path path = this.jaxbIndexOutDir.toPath();
        this.addResourceDirectory(path);
    }

    private void processClasses(IndexView index) {
        HashMap byPackage = new HashMap();
        Stream.of(XmlRootElement.class, XmlEnum.class, XmlType.class).map(Class::getName).map(DotName::createSimple).map(arg_0 -> ((IndexView)index).getAnnotations(arg_0)).flatMap(Collection::stream).map(AnnotationInstance::target).map(AnnotationTarget::asClass).map(ClassInfo::name).map(DotName::toString).forEach(name -> {
            int idx = name.lastIndexOf(46);
            String p = name.substring(0, idx);
            String c = name.substring(idx + 1);
            boolean skip = "WhenSkipSendToEndpointDefinition".equals(c);
            if (!skip) {
                byPackage.computeIfAbsent(p, s -> new TreeSet()).add(c);
            }
        });
        Path jaxbIndexDir = this.jaxbIndexOutDir.toPath();
        int count = 0;
        for (Map.Entry entry : byPackage.entrySet()) {
            String fn = ((String)entry.getKey()).replace('.', '/') + "/jaxb.index";
            if (this.project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(p -> p.resolve(fn)).anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) continue;
            StringBuilder sb = new StringBuilder(256);
            sb.append("# ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
            for (String s : (Set)entry.getValue()) {
                sb.append(s);
                sb.append("\n");
            }
            this.updateResource(jaxbIndexDir, fn, sb.toString());
            ++count;
        }
        if (count > 0) {
            this.getLog().info((CharSequence)("Generated " + this.jaxbIndexOutDir + " containing " + count + " jaxb.index elements"));
        }
    }

    private IndexView createIndex(List<String> locations) throws MojoExecutionException {
        if (this.index.exists()) {
            Index index;
            FileInputStream is = new FileInputStream(this.index);
            try {
                IndexReader r = new IndexReader((InputStream)is);
                index = r.read();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error", (Exception)e);
                }
            }
            ((InputStream)is).close();
            return index;
        }
        try {
            Indexer indexer = new Indexer();
            locations.stream().map(this::asFolder).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(this::walk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".class")).forEach(p -> this.index(indexer, (Path)p));
            return indexer.complete();
        }
        catch (IOError e) {
            throw new MojoExecutionException("Error", (Throwable)e);
        }
    }

    private Path asFolder(String p) {
        if (p.endsWith(".jar")) {
            Path path;
            block10: {
                File fp = new File(p);
                FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + fp.toURI()), Collections.emptyMap());
                try {
                    path = fs.getPath("/", new String[0]);
                    if (fs == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileSystemAlreadyExistsException e) {
                        return FileSystems.getFileSystem(URI.create("jar:" + fp.toURI())).getPath("/", new String[0]);
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }
                fs.close();
            }
            return path;
        }
        return Paths.get(p, new String[0]);
    }

    private Stream<Path> walk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void index(Indexer indexer, Path p) {
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            indexer.index(is);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

