/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.component.quartz.QuartzHelper;
import org.apache.camel.component.quartz.SchedulerInitTask;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="quartz")
public class QuartzComponent
extends DefaultComponent
implements ExtendedStartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzComponent.class);
    private final List<SchedulerInitTask> schedulerInitTasks = new ArrayList<SchedulerInitTask>();
    private volatile boolean schedulerInitTasksDone;
    @Metadata(label="advanced")
    private Scheduler scheduler;
    @Metadata(label="advanced")
    private SchedulerFactory schedulerFactory;
    @Metadata
    private String propertiesRef;
    @Metadata
    private Map properties;
    @Metadata
    private String propertiesFile;
    @Metadata(label="scheduler", defaultValue="true")
    private boolean autoStartScheduler = true;
    @Metadata(label="scheduler")
    private boolean interruptJobsOnShutdown;
    @Metadata(defaultValue="true")
    private boolean enableJmx = true;
    @Metadata
    private boolean prefixJobNameWithEndpointId;
    @Metadata(defaultValue="true")
    private boolean prefixInstanceName = true;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext camelContext) {
        super(camelContext);
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public boolean isPrefixJobNameWithEndpointId() {
        return this.prefixJobNameWithEndpointId;
    }

    public void setPrefixJobNameWithEndpointId(boolean prefixJobNameWithEndpointId) {
        this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public String getPropertiesRef() {
        return this.propertiesRef;
    }

    public void setPropertiesRef(String propertiesRef) {
        this.propertiesRef = propertiesRef;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public boolean isPrefixInstanceName() {
        return this.prefixInstanceName;
    }

    public void setPrefixInstanceName(boolean prefixInstanceName) {
        this.prefixInstanceName = prefixInstanceName;
    }

    public boolean isInterruptJobsOnShutdown() {
        return this.interruptJobsOnShutdown;
    }

    public void setInterruptJobsOnShutdown(boolean interruptJobsOnShutdown) {
        this.interruptJobsOnShutdown = interruptJobsOnShutdown;
    }

    public SchedulerFactory getSchedulerFactory() {
        if (this.schedulerFactory == null) {
            try {
                this.schedulerFactory = this.createSchedulerFactory();
            }
            catch (SchedulerException e) {
                throw new RuntimeException(e);
            }
        }
        return this.schedulerFactory;
    }

    private SchedulerFactory createSchedulerFactory() throws SchedulerException {
        StdSchedulerFactory answer;
        Properties prop = this.loadProperties();
        if (prop != null) {
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            prop.put("org.terracotta.quartz.skipUpdateCheck", "true");
            if (this.isPrefixInstanceName()) {
                String instName = this.createInstanceName(prop);
                prop.setProperty("org.quartz.scheduler.instanceName", instName);
            }
            if (this.isInterruptJobsOnShutdown()) {
                prop.setProperty("org.quartz.scheduler.interruptJobsOnShutdown", "true");
            }
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                prop.put("org.quartz.scheduler.jmx.export", "true");
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
            }
            answer = new StdSchedulerFactory(prop);
        } else {
            InputStream is = StdSchedulerFactory.class.getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: org/quartz/quartz.properties");
            }
            prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: org/quartz/quartz.properties", (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            if (this.isPrefixInstanceName()) {
                String instName = this.createInstanceName(prop);
                prop.setProperty("org.quartz.scheduler.instanceName", instName);
            }
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            prop.put("org.terracotta.quartz.skipUpdateCheck", "true");
            if (this.isInterruptJobsOnShutdown()) {
                prop.setProperty("org.quartz.scheduler.interruptJobsOnShutdown", "true");
            }
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                prop.put("org.quartz.scheduler.jmx.export", "true");
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
            }
            answer = new StdSchedulerFactory(prop);
        }
        if (LOG.isDebugEnabled()) {
            String name = prop.getProperty("org.quartz.scheduler.instanceName");
            LOG.debug("Creating SchedulerFactory: {} with properties: {}", (Object)name, (Object)prop);
        }
        return answer;
    }

    protected String createInstanceName(Properties prop) {
        Object instName = prop.getProperty("org.quartz.scheduler.instanceName");
        String identity = QuartzHelper.getQuartzContextName(this.getCamelContext());
        if (identity != null) {
            instName = instName == null ? "scheduler-" + identity : (String)instName + "-" + identity;
        }
        return instName;
    }

    public boolean isClustered() throws SchedulerException {
        return this.getScheduler().getMetaData().isJobStoreClustered();
    }

    private Properties loadProperties() throws SchedulerException {
        Properties answer = null;
        if (this.getProperties() != null) {
            answer = new Properties();
            answer.putAll((Map<?, ?>)this.getProperties());
        }
        if (answer == null && this.getPropertiesRef() != null) {
            Map map = (Map)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.getPropertiesRef(), Map.class);
            answer = new Properties();
            answer.putAll((Map<?, ?>)map);
        }
        if (answer == null && this.getPropertiesFile() != null) {
            LOG.info("Loading Quartz properties file from: {}", (Object)this.getPropertiesFile());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
                answer = new Properties();
                answer.load(is);
            }
            catch (IOException e) {
                try {
                    throw new SchedulerException("Error loading Quartz properties file: " + this.getPropertiesFile(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return answer;
    }

    public void setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void addScheduleInitTask(SchedulerInitTask task) {
        if (this.schedulerInitTasksDone) {
            try {
                task.initializeTask(this.scheduler);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        } else {
            this.schedulerInitTasks.add(task);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String cron;
        Boolean prefixJobNameWithEndpointId;
        Boolean autoStartScheduler = (Boolean)this.getAndRemoveParameter(parameters, "autoStartScheduler", Boolean.class);
        if (autoStartScheduler != null) {
            this.autoStartScheduler = autoStartScheduler;
        }
        if ((prefixJobNameWithEndpointId = (Boolean)this.getAndRemoveParameter(parameters, "prefixJobNameWithEndpointId", Boolean.class)) != null) {
            this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
        }
        Map triggerParameters = PropertiesHelper.extractProperties(parameters, (String)"trigger.");
        Map jobParameters = PropertiesHelper.extractProperties(parameters, (String)"job.");
        QuartzEndpoint result = new QuartzEndpoint(uri, this);
        TriggerKey triggerKey = this.createTriggerKey(uri, remaining, result);
        result.setTriggerKey(triggerKey);
        result.setTriggerParameters(triggerParameters);
        result.setJobParameters(jobParameters);
        if (autoStartScheduler != null) {
            result.setAutoStartScheduler(autoStartScheduler);
        }
        if (prefixJobNameWithEndpointId != null) {
            result.setPrefixJobNameWithEndpointId(prefixJobNameWithEndpointId);
        }
        if ((cron = (String)this.getAndRemoveParameter(parameters, "cron", String.class)) != null) {
            cron = cron.replace('+', ' ');
            result.setCron(cron);
        }
        this.setProperties((Endpoint)result, parameters);
        return result;
    }

    private TriggerKey createTriggerKey(String uri, String remaining, QuartzEndpoint endpoint) throws Exception {
        Object name;
        Object group;
        URI u = new URI(uri);
        String path = StringHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        if (host == null && (host = StringHelper.before((String)remaining, (String)"/")) == null) {
            host = remaining;
        }
        if (ObjectHelper.isNotEmpty((String)path) && ObjectHelper.isNotEmpty((String)host)) {
            group = host;
            name = path;
        } else {
            String camelContextName = QuartzHelper.getQuartzContextName(this.getCamelContext());
            group = camelContextName == null ? "Camel" : "Camel_" + camelContextName;
            name = host;
        }
        if (this.prefixJobNameWithEndpointId) {
            name = endpoint.getId() + "_" + (String)name;
        }
        return new TriggerKey((String)name, (String)group);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        }
    }

    private void createAndInitScheduler() throws SchedulerException {
        LOG.info("Create and initializing scheduler.");
        this.scheduler = this.createScheduler();
        SchedulerContext quartzContext = this.storeCamelContextInQuartzContext();
        quartzContext.computeIfAbsent((Object)"CamelQuartzJobsCount", k -> new AtomicInteger());
    }

    private SchedulerContext storeCamelContextInQuartzContext() throws SchedulerException {
        SchedulerContext quartzContext = this.scheduler.getContext();
        String camelContextName = QuartzHelper.getQuartzContextName(this.getCamelContext());
        LOG.debug("Storing camelContextName={} into Quartz Context space.", (Object)camelContextName);
        quartzContext.put("CamelQuartzCamelContext-" + camelContextName, (Object)this.getCamelContext());
        return quartzContext;
    }

    private Scheduler createScheduler() throws SchedulerException {
        return this.getSchedulerFactory().getScheduler();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduler != null) {
            if (this.isInterruptJobsOnShutdown()) {
                LOG.info("Shutting down scheduler. (will interrupts jobs to shutdown quicker.)");
                this.scheduler.shutdown(false);
                this.scheduler = null;
            } else {
                AtomicInteger number = (AtomicInteger)this.scheduler.getContext().get((Object)"CamelQuartzJobsCount");
                if (number != null && number.get() > 0) {
                    LOG.info("Cannot shutdown scheduler: {} as there are still {} jobs registered.", (Object)this.scheduler.getSchedulerName(), (Object)number.get());
                } else {
                    LOG.info("Shutting down scheduler. (will wait for all jobs to complete first.)");
                    this.scheduler.shutdown(true);
                    this.scheduler = null;
                }
            }
        }
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (alreadyStarted) {
            this.doStartScheduler();
        }
    }

    public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        this.doStartScheduler();
    }

    protected void doStartScheduler() throws Exception {
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        } else {
            this.storeCamelContextInQuartzContext();
        }
        for (SchedulerInitTask task : this.schedulerInitTasks) {
            task.initializeTask(this.scheduler);
        }
        this.schedulerInitTasks.clear();
        this.schedulerInitTasksDone = true;
        if (!this.autoStartScheduler) {
            LOG.info("Not starting scheduler because autoStartScheduler is set to false");
        } else if (this.scheduler.isStarted()) {
            LOG.info("The scheduler has already been started");
        } else {
            LOG.info("Starting scheduler");
            this.scheduler.start();
        }
    }
}

