/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.StartupListener;
import org.apache.camel.component.quartz2.QuartzEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzComponent
extends DefaultComponent
implements StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzComponent.class);
    private SchedulerFactory schedulerFactory;
    private Scheduler scheduler;
    private Properties properties;
    private String propertiesFile;
    private int startDelayedSeconds;
    private boolean autoStartScheduler = true;
    private boolean prefixJobNameWithEndpointId;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext camelContext) {
        super(camelContext);
    }

    public int getStartDelayedSeconds() {
        return this.startDelayedSeconds;
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setStartDelayedSeconds(int startDelayedSeconds) {
        this.startDelayedSeconds = startDelayedSeconds;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public SchedulerFactory getSchedulerFactory() throws SchedulerException {
        if (this.schedulerFactory == null) {
            this.schedulerFactory = this.createSchedulerFactory();
        }
        return this.schedulerFactory;
    }

    private SchedulerFactory createSchedulerFactory() throws SchedulerException {
        StdSchedulerFactory answer;
        Properties prop = this.loadProperties();
        if (prop != null) {
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            answer = new StdSchedulerFactory(prop);
        } else {
            InputStream is = StdSchedulerFactory.class.getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: org/quartz/quartz.properties");
            }
            prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: org/quartz/quartz.properties", (Throwable)e);
            }
            String identity = this.getCamelContext().getManagementName();
            String instName = prop.getProperty("org.quartz.scheduler.instanceName");
            instName = instName == null ? "scheduler-" + identity : instName + "-" + identity;
            prop.setProperty("org.quartz.scheduler.instanceName", instName);
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            answer = new StdSchedulerFactory(prop);
        }
        if (LOG.isDebugEnabled()) {
            String name = prop.getProperty("org.quartz.scheduler.instanceName");
            LOG.debug("Creating SchedulerFactory: {} with properties: {}", (Object)name, (Object)prop);
        }
        return answer;
    }

    private Properties loadProperties() throws SchedulerException {
        Properties answer = this.getProperties();
        if (answer == null && this.getPropertiesFile() != null) {
            LOG.info("Loading Quartz properties file from classpath: {}", (Object)this.getPropertiesFile());
            InputStream is = this.getCamelContext().getClassResolver().loadResourceAsStream(this.getPropertiesFile());
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: " + this.getPropertiesFile());
            }
            answer = new Properties();
            try {
                answer.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: " + this.getPropertiesFile(), (Throwable)e);
            }
        }
        return answer;
    }

    public void setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean prefixJobNameWithEndpointId;
        Boolean autoStartScheduler;
        Integer startDelayedSeconds = (Integer)this.getAndRemoveParameter(parameters, "startDelayedSeconds", Integer.class);
        if (startDelayedSeconds != null) {
            if (this.startDelayedSeconds != 0 && this.startDelayedSeconds != startDelayedSeconds) {
                LOG.warn("A Quartz job is already configured with a different 'startDelayedSeconds' configuration! All Quartz jobs must share the same 'startDelayedSeconds' configuration! Cannot apply the 'startDelayedSeconds' configuration!");
            } else {
                this.startDelayedSeconds = startDelayedSeconds;
            }
        }
        if ((autoStartScheduler = (Boolean)this.getAndRemoveParameter(parameters, "autoStartScheduler", Boolean.class)) != null) {
            this.autoStartScheduler = autoStartScheduler;
        }
        if ((prefixJobNameWithEndpointId = (Boolean)this.getAndRemoveParameter(parameters, "prefixJobNameWithEndpointId", Boolean.class)) != null) {
            this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
        }
        Map triggerParameters = IntrospectionSupport.extractProperties(parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties(parameters, (String)"job.");
        QuartzEndpoint result = new QuartzEndpoint(uri, this);
        TriggerKey triggerKey = this.createTriggerKey(uri, remaining, result);
        result.setTriggerKey(triggerKey);
        result.setTriggerParameters(triggerParameters);
        result.setJobParameters(jobParameters);
        return result;
    }

    private TriggerKey createTriggerKey(String uri, String remaining, QuartzEndpoint endpoint) throws Exception {
        String name;
        String group;
        URI u = new URI(uri);
        String path = ObjectHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        if (host == null) {
            host = ObjectHelper.before((String)remaining, (String)"/");
        }
        if (ObjectHelper.isNotEmpty((Object)path) && ObjectHelper.isNotEmpty((Object)host)) {
            group = host;
            name = path;
        } else {
            String camelContextName = this.getCamelContext().getManagementName();
            group = camelContextName == null ? "Camel" : "Camel_" + camelContextName;
            name = host;
        }
        if (this.prefixJobNameWithEndpointId) {
            name = endpoint.getId() + "_" + name;
        }
        return new TriggerKey(name, group);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        }
    }

    private void createAndInitScheduler() throws SchedulerException {
        LOG.info("Create and initializing scheduler.");
        this.scheduler = this.createScheduler();
        SchedulerContext quartzContext = this.scheduler.getContext();
        String camelContextName = this.getCamelContext().getManagementName();
        LOG.debug("Storing camelContextName={} into Quartz Context space.", (Object)camelContextName);
        quartzContext.put("CamelQuartzCamelContext-" + camelContextName, (Object)this.getCamelContext());
        AtomicInteger number = (AtomicInteger)quartzContext.get((Object)"CamelQuartzJobsCount");
        if (number == null) {
            number = new AtomicInteger(0);
            quartzContext.put("CamelQuartzJobsCount", (Object)number);
        }
    }

    private Scheduler createScheduler() throws SchedulerException {
        return this.getSchedulerFactory().getScheduler();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduler != null) {
            AtomicInteger number = (AtomicInteger)this.scheduler.getContext().get((Object)"CamelQuartzJobsCount");
            if (number != null && number.get() > 0) {
                LOG.info("Cannot shutdown scheduler: " + this.scheduler.getSchedulerName() + " as there are still " + number.get() + " jobs registered.");
            } else {
                LOG.info("Shutting down scheduler. (will wait for all jobs to complete first.)");
                this.scheduler.shutdown(true);
                this.scheduler = null;
            }
        }
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        }
        if (!this.autoStartScheduler) {
            LOG.info("Not starting scheduler because autoStartScheduler is set to false.");
        } else if (this.startDelayedSeconds > 0) {
            if (this.scheduler.isStarted()) {
                LOG.warn("The scheduler has already started. Cannot apply the 'startDelayedSeconds' configuration!");
            } else {
                LOG.info("Starting scheduler with startDelayedSeconds={}", (Object)this.startDelayedSeconds);
                this.scheduler.startDelayed(this.startDelayedSeconds);
            }
        } else if (this.scheduler.isStarted()) {
            LOG.info("The scheduler has already been started.");
        } else {
            LOG.info("Starting scheduler.");
            this.scheduler.start();
        }
    }
}

