/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Executors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class RabbitMQProducer
extends DefaultProducer {
    private final Connection conn;
    private final Channel channel;

    public RabbitMQProducer(RabbitMQEndpoint endpoint) throws IOException {
        super((Endpoint)endpoint);
        this.conn = endpoint.connect(Executors.newSingleThreadExecutor());
        this.channel = this.conn.createChannel();
    }

    public RabbitMQEndpoint getEndpoint() {
        return (RabbitMQEndpoint)super.getEndpoint();
    }

    public void shutdown() throws IOException {
        this.conn.close();
    }

    public void process(Exchange exchange) throws Exception {
        String exchangeName = (String)exchange.getIn().getHeader("rabbitmq.EXCHANGE_NAME", String.class);
        if (exchangeName == null) {
            exchangeName = this.getEndpoint().getExchangeName();
        }
        if (ObjectHelper.isEmpty((Object)exchangeName)) {
            throw new IllegalArgumentException("ExchangeName is not provided in header rabbitmq.EXCHANGE_NAME");
        }
        String key = (String)exchange.getIn().getHeader("rabbitmq.ROUTING_KEY", (Object)"", String.class);
        byte[] messageBodyBytes = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        AMQP.BasicProperties.Builder properties = this.buildProperties(exchange);
        this.channel.basicPublish(exchangeName, key, properties.build(), messageBodyBytes);
    }

    AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        Object contentType = exchange.getIn().getHeader("rabbitmq.CONTENT_TYPE");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = exchange.getIn().getHeader("rabbitmq.PRIORITY")) != null) {
            properties.priority(Integer.valueOf(Integer.parseInt(priority.toString())));
        }
        if ((messageId = exchange.getIn().getHeader("rabbitmq.MESSAGE_ID")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = exchange.getIn().getHeader("rabbitmq.CLUSTERID")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = exchange.getIn().getHeader("rabbitmq.REPLY_TO")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = exchange.getIn().getHeader("rabbitmq.CORRELATIONID")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = exchange.getIn().getHeader("rabbitmq.DELIVERY_MODE")) != null) {
            properties.deliveryMode(Integer.valueOf(Integer.parseInt(deliveryMode.toString())));
        }
        if ((userId = exchange.getIn().getHeader("rabbitmq.USERID")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = exchange.getIn().getHeader("rabbitmq.TYPE")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = exchange.getIn().getHeader("rabbitmq.CONTENT_ENCODING")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = exchange.getIn().getHeader("rabbitmq.EXPIRATION")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = exchange.getIn().getHeader("rabbitmq.APP_ID")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = exchange.getIn().getHeader("rabbitmq.TIMESTAMP")) != null) {
            properties.timestamp(new Date(Long.parseLong(timestamp.toString())));
        }
        return properties;
    }
}

