/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.component.rabbitmq.pool.PoolableChannelFactory;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class RabbitMQProducer
extends DefaultProducer {
    private Connection conn;
    private ObjectPool<Channel> channelPool;
    private ExecutorService executorService;
    private int closeTimeout = 30000;

    public RabbitMQProducer(RabbitMQEndpoint endpoint) throws IOException {
        super((Endpoint)endpoint);
    }

    public RabbitMQEndpoint getEndpoint() {
        return (RabbitMQEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(ChannelCallback<T> callback) throws Exception {
        Channel channel = (Channel)this.channelPool.borrowObject();
        try {
            T t = callback.doWithChannel(channel);
            return t;
        }
        finally {
            this.channelPool.returnObject((Object)channel);
        }
    }

    private void openConnectionAndChannelPool() throws Exception {
        this.log.trace("Creating connection...");
        this.conn = this.getEndpoint().connect(this.executorService);
        this.log.debug("Created connection: {}", (Object)this.conn);
        this.log.trace("Creating channel pool...");
        this.channelPool = new GenericObjectPool((PoolableObjectFactory)new PoolableChannelFactory(this.conn), this.getEndpoint().getChannelPoolMaxSize(), 1, this.getEndpoint().getChannelPoolMaxWait());
        if (this.getEndpoint().isDeclare()) {
            this.execute(new ChannelCallback<Void>(){

                @Override
                public Void doWithChannel(Channel channel) throws Exception {
                    RabbitMQProducer.this.getEndpoint().declareExchangeAndQueue(channel);
                    return null;
                }
            });
        }
    }

    protected void doStart() throws Exception {
        this.executorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelRabbitMQProducer[" + this.getEndpoint().getQueue() + "]");
        try {
            this.openConnectionAndChannelPool();
        }
        catch (IOException e) {
            this.log.warn("Failed to create connection", (Throwable)e);
        }
    }

    private void closeConnectionAndChannel() throws Exception {
        this.channelPool.close();
        if (this.conn != null) {
            this.log.debug("Closing connection: {} with timeout: {} ms.", (Object)this.conn, (Object)this.closeTimeout);
            this.conn.close(this.closeTimeout);
            this.conn = null;
        }
    }

    protected void doStop() throws Exception {
        this.closeConnectionAndChannel();
        if (this.executorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
    }

    public void process(Exchange exchange) throws Exception {
        String key;
        String exchangeName = (String)exchange.getIn().getHeader("rabbitmq.EXCHANGE_NAME", String.class);
        if (exchangeName == null || this.getEndpoint().isBridgeEndpoint()) {
            exchangeName = this.getEndpoint().getExchangeName();
        }
        if ((key = (String)exchange.getIn().getHeader("rabbitmq.ROUTING_KEY", null, String.class)) == null || this.getEndpoint().isBridgeEndpoint()) {
            String string = key = this.getEndpoint().getRoutingKey() == null ? "" : this.getEndpoint().getRoutingKey();
        }
        if (ObjectHelper.isEmpty((Object)key) && ObjectHelper.isEmpty((Object)exchangeName)) {
            throw new IllegalArgumentException("ExchangeName and RoutingKey is not provided in the endpoint: " + (Object)((Object)this.getEndpoint()));
        }
        byte[] messageBodyBytes = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        AMQP.BasicProperties properties = this.buildProperties(exchange).build();
        this.basicPublish(exchangeName, key, properties, messageBodyBytes);
    }

    private void basicPublish(final String exchange, final String routingKey, final AMQP.BasicProperties properties, final byte[] body) throws Exception {
        if (this.channelPool == null) {
            this.openConnectionAndChannelPool();
        }
        this.execute(new ChannelCallback<Void>(){

            @Override
            public Void doWithChannel(Channel channel) throws Exception {
                channel.basicPublish(exchange, routingKey, properties, body);
                return null;
            }
        });
    }

    AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        Object contentType = exchange.getIn().getHeader("rabbitmq.CONTENT_TYPE");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = exchange.getIn().getHeader("rabbitmq.PRIORITY")) != null) {
            properties.priority(Integer.valueOf(Integer.parseInt(priority.toString())));
        }
        if ((messageId = exchange.getIn().getHeader("rabbitmq.MESSAGE_ID")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = exchange.getIn().getHeader("rabbitmq.CLUSTERID")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = exchange.getIn().getHeader("rabbitmq.REPLY_TO")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = exchange.getIn().getHeader("rabbitmq.CORRELATIONID")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = exchange.getIn().getHeader("rabbitmq.DELIVERY_MODE")) != null) {
            properties.deliveryMode(Integer.valueOf(Integer.parseInt(deliveryMode.toString())));
        }
        if ((userId = exchange.getIn().getHeader("rabbitmq.USERID")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = exchange.getIn().getHeader("rabbitmq.TYPE")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = exchange.getIn().getHeader("rabbitmq.CONTENT_ENCODING")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = exchange.getIn().getHeader("rabbitmq.EXPIRATION")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = exchange.getIn().getHeader("rabbitmq.APP_ID")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = exchange.getIn().getHeader("rabbitmq.TIMESTAMP")) != null) {
            properties.timestamp(new Date(Long.parseLong(timestamp.toString())));
        }
        Map headers = exchange.getIn().getHeaders();
        HashMap filteredHeaders = new HashMap();
        for (Map.Entry header : headers.entrySet()) {
            Object value = this.getValidRabbitMQHeaderValue(header.getValue());
            if (value != null) {
                filteredHeaders.put(header.getKey(), header.getValue());
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            if (header.getValue() == null) {
                this.log.debug("Ignoring header: {} with null value", header.getKey());
                continue;
            }
            this.log.debug("Ignoring header: {} of class: {} with value: {}", new Object[]{header.getKey(), ObjectHelper.classCanonicalName(header.getValue()), header.getValue()});
        }
        properties.headers(filteredHeaders);
        return properties;
    }

    private Object getValidRabbitMQHeaderValue(Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (headerValue instanceof byte[]) {
            return headerValue;
        }
        return null;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    private static interface ChannelCallback<T> {
        public T doWithChannel(Channel var1) throws Exception;
    }
}

