/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.maven.model.RouteCoverageNode;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.helper.RouteCoverageHelper;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CoverageData;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.FileUtil;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Mojo(name="route-coverage", threadSafe=true)
public class RouteCoverageMojo
extends AbstractExecMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="camel.failOnError", defaultValue="false")
    private boolean failOnError;
    private byte coverageThreshold = (byte)100;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    @Parameter(property="camel.anonymousRoutes", defaultValue="false")
    private boolean anonymousRoutes;
    @Parameter(property="camel.generateJacocoXmlReport", defaultValue="false")
    private boolean generateJacocoXmlReport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String baseDir;
        String fqn;
        String dir;
        LinkedHashSet<File> javaFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> xmlFiles = new LinkedHashSet<File>();
        List list = this.project.getCompileSourceRoots();
        for (Object obj : list) {
            dir = (String)obj;
            this.findJavaFiles(new File(dir), javaFiles);
        }
        list = this.project.getResources();
        for (Object obj : list) {
            dir = (Resource)obj;
            this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
        }
        if (this.includeTest) {
            list = this.project.getTestCompileSourceRoots();
            for (Object obj : list) {
                dir = (String)obj;
                this.findJavaFiles(new File(dir), javaFiles);
            }
            list = this.project.getTestResources();
            for (Object obj : list) {
                dir = (Resource)obj;
                this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
        }
        ArrayList routeTrees = new ArrayList();
        for (File file : javaFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fqn = file.getPath();
                baseDir = ".";
                JavaType out = Roaster.parse((File)file);
                if (!(out instanceof JavaClassSource)) continue;
                JavaClassSource clazz = (JavaClassSource)out;
                List result = RouteBuilderParser.parseRouteBuilderTree((JavaClassSource)clazz, (String)baseDir, (String)fqn, (boolean)true);
                routeTrees.addAll(result);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        for (File file : xmlFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fqn = file.getPath();
                baseDir = ".";
                FileInputStream is = new FileInputStream(file);
                List result = XmlRouteParser.parseXmlRouteTree((InputStream)is, (String)baseDir, (String)fqn);
                routeTrees.addAll(result);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)("Discovered " + routeTrees.size() + " routes"));
        long anonymous = routeTrees.stream().filter(t -> t.getRouteId() == null).count();
        if (!this.anonymousRoutes && anonymous > 0L) {
            this.getLog().warn((CharSequence)("Discovered " + anonymous + " anonymous routes. Add route ids to these routes for route coverage support"));
        }
        AtomicInteger notCovered = new AtomicInteger();
        List routeIdTrees = routeTrees.stream().filter(t -> t.getRouteId() != null).collect(Collectors.toList());
        List<CamelNodeDetails> anonymousRouteTrees = routeTrees.stream().filter(t -> t.getRouteId() == null).collect(Collectors.toList());
        Document document = null;
        File file = null;
        Element report = null;
        if (this.generateJacocoXmlReport) {
            try {
                file = new File(this.project.getBasedir() + "/target/site/jacoco");
                if (!file.exists()) {
                    file.mkdirs();
                }
                document = RouteCoverageMojo.createDocument();
                report = document.createElement("report");
                RouteCoverageMojo.createAttrString(document, report, "name", "Camel Xml");
                document.appendChild(report);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error generating Jacoco XML report due " + e.getMessage()));
            }
        }
        for (CamelNodeDetails t2 : routeIdTrees) {
            String routeId = t2.getRouteId();
            String fileName = this.stripRootPath(this.asRelativeFile(t2.getFileName()));
            String sourceFileName = new File(fileName).getName();
            String packageName = new File(fileName).getParent();
            Object pack = null;
            if (this.generateJacocoXmlReport && report != null) {
                pack = document.createElement("package");
                RouteCoverageMojo.createAttrString(document, (Element)pack, "name", packageName);
                report.appendChild((Node)pack);
            }
            try {
                List list2 = RouteCoverageHelper.parseDumpRouteCoverageByRouteId((String)"target/camel-route-coverage", (String)routeId);
                if (list2.isEmpty()) {
                    this.getLog().warn((CharSequence)("No route coverage data found for route: " + routeId + ". Make sure to enable route coverage in your unit tests and assign unique route ids to your routes. Also remember to run unit tests first."));
                    continue;
                }
                List<RouteCoverageNode> coverage = RouteCoverageMojo.gatherRouteCoverageSummary(Collections.singletonList((Object)t2), list2);
                String out = this.templateCoverageData(fileName, routeId, coverage, notCovered);
                this.getLog().info((CharSequence)("Route coverage summary:\n\n" + out));
                this.getLog().info((CharSequence)"");
                if (!this.generateJacocoXmlReport || report == null) continue;
                this.appendSourcefileNode(document, sourceFileName, (Element)pack, coverage);
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Error during gathering route coverage data for route: " + routeId, exception);
            }
        }
        if (this.generateJacocoXmlReport && report != null) {
            try {
                this.getLog().info((CharSequence)("Generating Jacoco XML report: " + file));
                RouteCoverageMojo.createJacocoXmlFile(document, file);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error generating Jacoco XML report due " + e.getMessage()));
            }
        }
        if (this.anonymousRoutes && !anonymousRouteTrees.isEmpty()) {
            try {
                Map datas = RouteCoverageHelper.parseDumpRouteCoverageByClassAndTestMethod((String)"target/camel-route-coverage");
                if (datas.isEmpty()) {
                    this.getLog().warn((CharSequence)"No route coverage data found. Make sure to enable route coverage in your unit tests. Also remember to run unit tests first.");
                } else {
                    Map<String, List<CamelNodeDetails>> routes = this.groupAnonymousRoutesByClassName(anonymousRouteTrees);
                    for (Map.Entry<String, List<CamelNodeDetails>> t3 : routes.entrySet()) {
                        ArrayList<RouteCoverageNode> coverage = new ArrayList<RouteCoverageNode>();
                        String className = t3.getKey();
                        for (Map.Entry entry : datas.entrySet()) {
                            String key = (String)entry.getKey();
                            String dataClassName = key.substring(0, key.indexOf(45));
                            if (!dataClassName.equals(className)) continue;
                            List<RouteCoverageNode> result = RouteCoverageMojo.gatherRouteCoverageSummary(t3.getValue(), (List)entry.getValue());
                            this.mergeCoverageData(coverage, result);
                        }
                        if (coverage.isEmpty()) continue;
                        String fileName = this.stripRootPath(this.asRelativeFile(t3.getValue().get(0).getFileName()));
                        String string = this.templateCoverageData(fileName, null, coverage, notCovered);
                        this.getLog().info((CharSequence)("Route coverage summary:\n\n" + string));
                        this.getLog().info((CharSequence)"");
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error during gathering route coverage data", e);
            }
        }
        if (this.failOnError && notCovered.get() > 0) {
            throw new MojoExecutionException("There are " + notCovered.get() + " route(s) not fully covered!");
        }
    }

    private Map<String, List<CamelNodeDetails>> groupAnonymousRoutesByClassName(List<CamelNodeDetails> anonymousRouteTrees) {
        LinkedHashMap<String, List<CamelNodeDetails>> answer = new LinkedHashMap<String, List<CamelNodeDetails>>();
        for (CamelNodeDetails t : anonymousRouteTrees) {
            String fileName = this.asRelativeFile(t.getFileName());
            String className = FileUtil.stripExt((String)FileUtil.stripPath((String)fileName));
            List list = answer.computeIfAbsent(className, k -> new ArrayList());
            list.add(t);
        }
        return answer;
    }

    private void mergeCoverageData(List<RouteCoverageNode> coverage, List<RouteCoverageNode> result) {
        ArrayList<RouteCoverageNode> toBeAdded = new ArrayList<RouteCoverageNode>();
        ListIterator<RouteCoverageNode> it = null;
        for (RouteCoverageNode node : result) {
            RouteCoverageNode existing;
            RouteCoverageNode routeCoverageNode = existing = (it = this.positionToLineNumber(it, coverage, node.getLineNumber())).hasNext() ? it.next() : null;
            if (existing != null) {
                int count = existing.getCount() + node.getCount();
                existing.setCount(count);
                continue;
            }
            toBeAdded.add(node);
        }
        if (!toBeAdded.isEmpty()) {
            coverage.addAll(toBeAdded);
        }
    }

    private ListIterator<RouteCoverageNode> positionToLineNumber(ListIterator<RouteCoverageNode> it, List<RouteCoverageNode> coverage, int lineNumber) {
        if (it == null || !it.hasNext()) {
            it = coverage.listIterator();
        }
        while (it.hasNext()) {
            RouteCoverageNode node = it.next();
            if (node.getLineNumber() != lineNumber) continue;
            it.previous();
            return it;
        }
        return it;
    }

    private String templateCoverageData(String fileName, String routeId, List<RouteCoverageNode> model, AtomicInteger notCovered) throws MojoExecutionException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream sw = new PrintStream(bos);
        if (model.get(0).getClassName() != null) {
            sw.println("Class:\t" + model.get(0).getClassName());
        } else {
            sw.println("File:\t" + fileName);
        }
        if (routeId != null) {
            sw.println("Route:\t" + routeId);
        }
        sw.println();
        sw.println(String.format("%8s    %8s    %s", "Line #", "Count", "Route"));
        sw.println(String.format("%8s    %8s    %s", "------", "-----", "-----"));
        int covered = 0;
        for (RouteCoverageNode node : model) {
            if (node.getCount() > 0) {
                ++covered;
            }
            String pad = RouteCoverageMojo.padString(node.getLevel());
            sw.println(String.format("%8s    %8s    %s", node.getLineNumber(), node.getCount(), pad + node.getName()));
        }
        double percentage = (double)covered / (double)model.size() * 100.0;
        boolean success = true;
        if (covered != model.size() && percentage < (double)this.coverageThreshold) {
            notCovered.incrementAndGet();
            success = false;
        }
        sw.println();
        sw.println("Coverage: " + covered + " out of " + model.size() + " (" + String.format("%.1f", percentage) + "% / threshold " + this.coverageThreshold + ".0%)");
        sw.println("Status: " + (success ? "Success" : "Failed"));
        sw.println();
        return bos.toString();
    }

    private static List<RouteCoverageNode> gatherRouteCoverageSummary(List<CamelNodeDetails> route, List<CoverageData> coverageData) {
        ArrayList<RouteCoverageNode> answer = new ArrayList<RouteCoverageNode>();
        Iterator<CoverageData> it = coverageData.iterator();
        for (CamelNodeDetails r : route) {
            AtomicInteger level = new AtomicInteger();
            RouteCoverageMojo.gatherRouteCoverageSummary(r, it, level, answer);
        }
        return answer;
    }

    private static void gatherRouteCoverageSummary(CamelNodeDetails node, Iterator<CoverageData> it, AtomicInteger level, List<RouteCoverageNode> answer) {
        boolean skipData;
        boolean bl = skipData = "policy".equals(node.getName()) || "transacted".equals(node.getName());
        if (skipData) {
            for (CamelNodeDetails child : node.getOutputs()) {
                RouteCoverageMojo.gatherRouteCoverageSummary(child, it, level, answer);
            }
            return;
        }
        RouteCoverageNode data = new RouteCoverageNode();
        data.setName(node.getName());
        data.setLineNumber(Integer.valueOf(node.getLineNumber()));
        data.setLevel(level.get());
        data.setClassName(node.getClassName());
        data.setMethodName(node.getMethodName());
        answer.add(data);
        boolean found = false;
        while (!found && it.hasNext()) {
            CoverageData holder = it.next();
            found = holder.getNode().equals(node.getName());
            if (!found) continue;
            data.setCount(holder.getCount());
        }
        if (node.getOutputs() != null) {
            level.addAndGet(1);
            for (CamelNodeDetails child : node.getOutputs()) {
                RouteCoverageMojo.gatherRouteCoverageSummary(child, it, level, answer);
            }
            level.addAndGet(-1);
        }
    }

    private static String padString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private void findJavaFiles(File dir, Set<File> javaFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".java")) {
                    javaFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findJavaFiles(file, javaFiles);
            }
        }
    }

    private void findXmlFiles(File dir, Set<File> xmlFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".xml")) {
                    xmlFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findXmlFiles(file, xmlFiles);
            }
        }
    }

    private boolean matchFile(File file) {
        boolean match;
        String fqn;
        if (this.excludes == null && this.includes == null) {
            return true;
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes.split(",")) {
                exclude = exclude.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = PatternHelper.matchPattern((String)fqn, (String)exclude) || PatternHelper.matchPattern((String)file.getName(), (String)exclude);
                if (!match) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes.split(",")) {
                include = include.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = PatternHelper.matchPattern((String)fqn, (String)include) || PatternHelper.matchPattern((String)file.getName(), (String)include);
                if (!match) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String asRelativeFile(String name) {
        String answer = name;
        String base = this.project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    private String stripRootPath(String name) {
        String dir;
        Resource resource;
        String dir2;
        List list = this.project.getCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        list = this.project.getTestCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        List resources = this.project.getResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        resources = this.project.getTestResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return name;
    }

    private void appendSourcefileNode(Document document, String sourceFileName, Element pack, List<RouteCoverageNode> coverage) {
        Element sourcefile = document.createElement("sourcefile");
        RouteCoverageMojo.createAttrString(document, sourcefile, "name", sourceFileName);
        pack.appendChild(sourcefile);
        int covered = 0;
        int missed = 0;
        for (RouteCoverageNode node : coverage) {
            int missedCount = 0;
            if (node.getCount() > 0) {
                ++covered;
            } else {
                ++missedCount;
                ++missed;
            }
            Element line = document.createElement("line");
            RouteCoverageMojo.createAttrInt(document, line, "nr", node.getLineNumber());
            RouteCoverageMojo.createAttrInt(document, line, "mi", missedCount);
            RouteCoverageMojo.createAttrInt(document, line, "ci", node.getCount());
            RouteCoverageMojo.createAttrInt(document, line, "mb", 0);
            RouteCoverageMojo.createAttrInt(document, line, "cb", 0);
            sourcefile.appendChild(line);
        }
        Element counter = document.createElement("counter");
        RouteCoverageMojo.createAttrString(document, counter, "type", "LINE");
        RouteCoverageMojo.createAttrInt(document, counter, "missed", missed);
        RouteCoverageMojo.createAttrInt(document, counter, "covered", covered);
        sourcefile.appendChild(counter);
    }

    private static Attr createAttrInt(Document doc, Element e, String name, Integer value) {
        Attr a = doc.createAttribute(name);
        a.setValue(value.toString());
        e.setAttributeNode(a);
        return a;
    }

    private static Attr createAttrString(Document doc, Element e, String name, String value) {
        Attr a = doc.createAttribute(name);
        a.setValue(value);
        e.setAttributeNode(a);
        return a;
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        documentFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private static void createJacocoXmlFile(Document document, File file) throws TransformerException {
        String xmlFilePath = file.toString() + "/xmlJacoco.xml";
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(xmlFilePath));
        transformer.transform(domSource, streamResult);
    }
}

