/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.maven.htmlxlsx.model.ChildEip;
import org.apache.camel.maven.htmlxlsx.model.ChildEipStatistic;
import org.apache.camel.maven.htmlxlsx.model.Components;
import org.apache.camel.maven.htmlxlsx.model.EipAttribute;
import org.apache.camel.maven.htmlxlsx.model.EipStatistic;
import org.apache.camel.maven.htmlxlsx.model.Route;
import org.apache.camel.maven.htmlxlsx.model.RouteStatistic;
import org.apache.camel.maven.htmlxlsx.model.RouteTotalsStatistic;
import org.apache.camel.maven.htmlxlsx.model.TestResult;
import org.apache.camel.maven.htmlxlsx.process.FileUtil;
import org.apache.camel.maven.htmlxlsx.process.TemplateRenderer;
import org.apache.camel.maven.htmlxlsx.process.TestResultParser;
import org.apache.camel.maven.htmlxlsx.process.XmlToCamelRouteCoverageConverter;
import org.apache.maven.project.MavenProject;

public class CoverageResultsProcessor {
    private static final String DETAILS_FILE = "/details.html";
    private static final String INDEX_FILE = "/index.html";
    private static final String REST = "rest";
    private static final String FROM = "from";
    private static final String URI = "uri";
    private final Map<String, Route> routeMap = new TreeMap<String, Route>();
    private final Map<String, RouteStatistic> routeStatisticMap = new TreeMap<String, RouteStatistic>();
    private final List<TestResult> testResults = new ArrayList<TestResult>();
    private final RouteTotalsStatistic routeTotalsStatistic = new RouteTotalsStatistic();
    private final FileUtil fileUtil = new FileUtil();
    private final TestResultParser testResultParser = new TestResultParser();
    private final XmlToCamelRouteCoverageConverter xmlToCamelRouteCoverageConverter = new XmlToCamelRouteCoverageConverter();

    public String generateReport(MavenProject project, File xmlPath, File htmlPath) throws IOException {
        String out;
        this.parseAllTestResults(xmlPath);
        if (this.testResults.size() > 0) {
            this.gatherBestRouteCoverages();
            this.squashDuplicateRoutes();
            this.generateRouteStatistics(project.getName(), htmlPath);
            this.generateEipStatistics();
            this.generateHtml(htmlPath);
            out = String.format("Generated HTML reports for %d routes%n%n", this.routeStatisticMap.size());
        } else {
            out = "No routes found. No HTML reports were generated%n";
        }
        return out;
    }

    protected void parseAllTestResults(File xmlPath) throws IOException {
        Set<String> testInputs = this.fileUtil.filesInDirectory(xmlPath);
        for (String inputFile : testInputs) {
            TestResult testResult = this.parseTestResult(inputFile);
            this.testResults.add(testResult);
        }
    }

    protected TestResult parseTestResult(String inputFile) throws IOException {
        String fileAsString = this.fileUtil.readFile(inputFile);
        TestResult testResult = this.xmlToCamelRouteCoverageConverter.convert(fileAsString);
        assert (testResult != null);
        return this.testResultParser.parse(testResult);
    }

    protected void generateEipStatistics() {
        for (Route route : this.routeMap.values()) {
            HashMap<Integer, List<EipStatistic>> eipStatisticMap = new HashMap<Integer, List<EipStatistic>>();
            Components components = route.getComponents();
            Map<String, List<EipAttribute>> eipAttributesMap = components.getAttributeMap();
            eipAttributesMap.forEach((key, eipAttributes) -> {
                if (!key.equals(REST)) {
                    eipAttributes.forEach(eipAttribute -> {
                        EipStatistic eipStatistic = new EipStatistic();
                        eipStatistic.setId((String)key);
                        eipStatistic.setTested(eipAttribute.getExchangesTotal() > 0);
                        eipStatistic.setTotalProcessingTime(eipAttribute.getTotalProcessingTime());
                        eipStatistic.setProperties(eipAttribute.getProperties());
                        eipAttribute.getChildEipMap().forEach((childKey, childEipList) -> childEipList.forEach(childEip -> {
                            ChildEipStatistic childEipStatistic = new ChildEipStatistic();
                            childEipStatistic.setId(childEip.getId());
                            this.generateChildEipStatistics((ChildEip)childEip, childEipStatistic);
                            eipStatistic.getChildEipStatisticMap().put((String)childKey, childEipStatistic);
                        }));
                        List<EipStatistic> eipStatisticList = eipStatisticMap.containsKey(eipAttribute.getIndex()) ? (List)eipStatisticMap.get(eipAttribute.getIndex()) : new ArrayList<EipStatistic>();
                        eipStatisticList.add(eipStatistic);
                        eipStatisticMap.put(eipAttribute.getIndex(), eipStatisticList);
                    });
                }
            });
            RouteStatistic routeStatistic = this.routeStatisticMap.get(route.getId());
            routeStatistic.setEipStatisticMap(eipStatisticMap);
            this.routeStatisticMap.put(route.getId(), routeStatistic);
        }
    }

    protected void generateChildEipStatistics(ChildEip childEip, ChildEipStatistic childEipStatistic) {
        childEip.getEipAttributeMap().forEach((key, value) -> {
            if (value instanceof EipAttribute) {
                EipAttribute eipAttribute = (EipAttribute)value;
                EipStatistic eipStatistic = new EipStatistic();
                eipStatistic.setId((String)key);
                eipStatistic.setTested(eipAttribute.getExchangesTotal() > 0);
                eipStatistic.setTotalProcessingTime(eipAttribute.getTotalProcessingTime());
                eipStatistic.setProperties(eipAttribute.getProperties());
                childEipStatistic.getEipStatisticMap().put(eipAttribute.getIndex(), eipStatistic);
            } else if (value instanceof String) {
                Properties properties = new Properties();
                properties.put("value", value);
                EipStatistic eipStatistic = new EipStatistic();
                eipStatistic.setId((String)key);
                eipStatistic.setProperties(properties);
                childEipStatistic.getEipStatisticMap().put(0, eipStatistic);
            }
        });
    }

    protected void generateHtml(File outputPath) throws IOException {
        for (RouteStatistic routeStatistic : this.routeStatisticMap.values()) {
            this.writeDetailsAsHtml(routeStatistic, outputPath);
        }
    }

    protected void gatherBestRouteCoverages() {
        this.testResults.forEach(testResult -> {
            List<Route> routeList = testResult.getCamelContextRouteCoverage().getRoutes().getRouteList();
            routeList.forEach(route -> {
                String routeId = route.getId();
                Route mappedRoute = this.routeMap.get(routeId);
                if (mappedRoute == null) {
                    this.routeMap.put(routeId, (Route)route);
                    mappedRoute = this.routeMap.get(routeId);
                }
                try {
                    if (route.getExchangesTotal() > mappedRoute.getExchangesTotal()) {
                        this.routeMap.put(routeId, (Route)route);
                    }
                }
                catch (Exception t) {
                    System.out.println(t.getClass().toString());
                    System.out.printf("routeID: %s%n", routeId);
                    System.out.printf("route: %s%n", route);
                    System.out.printf("mappedRoute: %s%n", mappedRoute != null ? mappedRoute.toString() : "null");
                }
            });
        });
    }

    protected void squashDuplicateRoutes() {
        TreeMap<String, String> squashMap = new TreeMap<String, String>();
        this.routeMap.forEach((key, route) -> {
            Map from = (Map)route.getComponentsMap().get(FROM);
            String uri = from.get(URI).toString();
            squashMap.put(uri, (String)key);
        });
        TreeMap squashedRouteMap = new TreeMap();
        squashMap.forEach((key, value) -> squashedRouteMap.put(value, this.routeMap.get(value)));
        this.routeMap.clear();
        this.routeMap.putAll(squashedRouteMap);
    }

    protected String generateRouteStatistics(String project, File outputPath) throws IOException {
        this.routeMap.values().forEach(route -> {
            String routeId = route.getId();
            RouteStatistic routeStatistic = this.getRouteStatistic(routeId);
            routeStatistic = this.recalculate((Route)route, routeStatistic);
            this.routeStatisticMap.put(routeId, routeStatistic);
            this.addToRouteTotals(routeStatistic);
        });
        return this.writeReportIndex(project, outputPath);
    }

    protected void addToRouteTotals(RouteStatistic routeStatistic) {
        this.routeTotalsStatistic.incrementTotalEips(routeStatistic.getTotalEips());
        this.routeTotalsStatistic.incrementTotalEipsTested(routeStatistic.getTotalEipsTested());
        this.routeTotalsStatistic.incrementTotalProcessingTime(routeStatistic.getTotalProcessingTime());
    }

    protected RouteStatistic getRouteStatistic(String routeId) {
        RouteStatistic routeStatistic;
        if (!this.routeStatisticMap.containsKey(routeId)) {
            routeStatistic = new RouteStatistic();
            routeStatistic.setId(routeId);
            this.routeStatisticMap.put(routeId, routeStatistic);
        } else {
            routeStatistic = this.routeStatisticMap.get(routeId);
        }
        return routeStatistic;
    }

    protected RouteStatistic recalculate(Route route, RouteStatistic routeStatistic) {
        AtomicInteger totalEips = new AtomicInteger(routeStatistic.getTotalEips());
        AtomicInteger totalEipsTested = new AtomicInteger(routeStatistic.getTotalEipsTested());
        AtomicInteger totalProcessingTime = new AtomicInteger(routeStatistic.getTotalProcessingTime());
        route.getComponents().getAttributeMap().values().forEach(eipAttributes -> {
            if (!routeStatistic.isTotalEipsInitialized()) {
                totalEips.getAndAdd(eipAttributes.size());
            }
            eipAttributes.forEach(eipAttribute -> {
                totalEipsTested.getAndAdd(eipAttribute.getExchangesTotal());
                totalProcessingTime.getAndAdd(eipAttribute.getTotalProcessingTime());
            });
        });
        if (totalEipsTested.get() > totalEips.get()) {
            totalEipsTested.set(totalEips.get());
        }
        int coverage = 0;
        if (totalEips.get() > 0) {
            coverage = 100 * totalEipsTested.get() / totalEips.get();
        }
        RouteStatistic retval = new RouteStatistic();
        retval.setId(route.getId());
        retval.setTotalEips(totalEips.get());
        retval.setTotalEipsTested(totalEipsTested.get());
        retval.setTotalProcessingTime(totalProcessingTime.get());
        retval.setCoverage(coverage);
        retval.setTotalEipsInitialized(true);
        return retval;
    }

    protected void writeDetailsAsHtml(RouteStatistic routeStatistic, File outputPath) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("route", routeStatistic);
        data.put("eips", routeStatistic.getEipStatisticMap().entrySet());
        String rendered = TemplateRenderer.render(DETAILS_FILE, data);
        this.fileUtil.write(rendered, routeStatistic.getId(), outputPath);
    }

    protected String writeReportIndex(String project, File outputPath) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("project", project);
        data.put("routes", this.routeStatisticMap.values());
        data.put("totals", this.routeTotalsStatistic);
        String rendered = TemplateRenderer.render(INDEX_FILE, data);
        return this.fileUtil.write(rendered, "index", outputPath);
    }

    public void writeCSS(File cssPath) throws IOException {
        this.writeStaticFile("static/css/", "datatables.min.css", cssPath);
    }

    public void writeJS(File jsPath) throws IOException {
        this.writeStaticFile("static/js/", "datatables.min.js", jsPath);
    }

    protected void writeStaticFile(String baseInputPath, String filename, File baseOutputPath) throws IOException {
        String inputPath = Path.of(baseInputPath, filename).toString();
        String css = this.fileUtil.readFileFromClassPath(inputPath);
        Path outputPath = Paths.get(baseOutputPath.getPath(), filename);
        this.fileUtil.write(css, outputPath);
    }
}

