/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestApiComponent;
import org.apache.camel.component.rest.RestApiProducer;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestApiProcessorFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.16.0", scheme="rest-api", title="REST API", syntax="rest-api:path", remote=false, consumerOnly=true, category={Category.CORE, Category.REST}, lenientProperties=true)
public class RestApiEndpoint
extends DefaultEndpoint {
    public static final String DEFAULT_API_COMPONENT_NAME = "openapi";
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/restapi/";
    @UriPath
    @Metadata(required=true)
    private String path;
    @UriParam
    private String consumerComponentName;
    @UriParam
    private String apiComponentName;
    private Map<String, Object> parameters;

    public RestApiEndpoint(String endpointUri, RestApiComponent component) {
        super(endpointUri, (Component)component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public RestApiComponent getComponent() {
        return (RestApiComponent)super.getComponent();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getConsumerComponentName() {
        return this.consumerComponentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public String getApiComponentName() {
        return this.apiComponentName;
    }

    public void setApiComponentName(String apiComponentName) {
        this.apiComponentName = apiComponentName;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Producer createProducer() throws Exception {
        FactoryFinder finder;
        String name;
        RestApiProcessorFactory factory = null;
        RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)this.getConsumerComponentName());
        Set factories = this.getCamelContext().getRegistry().findByType(RestApiProcessorFactory.class);
        if (factories != null && factories.size() == 1) {
            factory = (RestApiProcessorFactory)factories.iterator().next();
        }
        if (factory == null) {
            String string = name = this.apiComponentName != null ? this.apiComponentName : config.getApiComponent();
            if (name == null) {
                name = DEFAULT_API_COMPONENT_NAME;
            }
            finder = this.getCamelContext().getCamelContextExtension().getFactoryFinder(RESOURCE_PATH);
            factory = finder.newInstance(name, RestApiProcessorFactory.class).orElse(null);
        }
        if (factory == null) {
            String string = name = this.apiComponentName != null ? this.apiComponentName : config.getApiComponent();
            if (name == null) {
                name = "swagger";
            }
            finder = this.getCamelContext().getCamelContextExtension().getFactoryFinder(RESOURCE_PATH);
            factory = finder.newInstance(name, RestApiProcessorFactory.class).orElse(null);
        }
        if (factory != null) {
            Object path;
            String host = "";
            int port = 80;
            if (config.getApiHost() != null) {
                host = config.getApiHost();
            } else if (config.getHost() != null) {
                host = config.getHost();
            }
            int num = config.getPort();
            if (num > 0) {
                port = num;
            }
            if (ObjectHelper.isEmpty((String)host)) {
                if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                    host = "0.0.0.0";
                } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                    host = HostUtils.getLocalHostName();
                } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                    host = HostUtils.getLocalIp();
                }
                String targetHost = host + (String)(port != 80 ? ":" + port : "");
                this.getParameters().put("host", targetHost);
            }
            if ((path = this.getPath()) != null && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            Processor processor = factory.createApiProcessor(this.getCamelContext(), (String)path, config, this.getParameters());
            return new RestApiProducer((Endpoint)this, processor);
        }
        throw new IllegalStateException("Cannot find RestApiProcessorFactory in Registry or classpath (such as the camel-openapi-java component)");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Set factories;
        RestApiConsumerFactory factory = null;
        String cname = null;
        if (this.getConsumerComponentName() != null) {
            Component comp = this.getCamelContext().getRegistry().lookupByName(this.getConsumerComponentName());
            if (comp instanceof RestApiConsumerFactory) {
                factory = (RestApiConsumerFactory)comp;
            } else {
                comp = this.getCamelContext().getComponent(this.getConsumerComponentName());
                if (comp instanceof RestApiConsumerFactory) {
                    factory = (RestApiConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + this.getConsumerComponentName() + " is not a RestApiConsumerFactory");
                }
                throw new NoSuchBeanException(this.getConsumerComponentName(), RestApiConsumerFactory.class.getName());
            }
            cname = this.getConsumerComponentName();
        }
        if (factory == null) {
            for (String name : this.getCamelContext().getComponentNames()) {
                Component comp = this.getCamelContext().getComponent(name);
                if (!(comp instanceof RestApiConsumerFactory)) continue;
                factory = (RestApiConsumerFactory)comp;
                cname = name;
                break;
            }
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestApiConsumerFactory.class)) != null && factories.size() == 1) {
            factory = (RestApiConsumerFactory)factories.iterator().next();
        }
        if (factory != null) {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), cname);
            Object path = this.getPath();
            if (path != null && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            Consumer consumer = factory.createApiConsumer(this.getCamelContext(), processor, (String)path, config, this.getParameters());
            this.configureConsumer(consumer);
            return consumer;
        }
        throw new IllegalStateException("Cannot find RestApiConsumerFactory in Registry or as a Component to use");
    }

    public boolean isLenientProperties() {
        return true;
    }
}

