/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StringSource;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.MessageHelper;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestletBinding
implements RestletBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestletBinding.class);
    private static final String RFC_2822_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss Z";
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateExchangeFromRestletRequest(Request request, Response response, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        inMessage.setHeader("CamelRestletRequest", (Object)request);
        inMessage.setHeader("CamelRestletResponse", (Object)response);
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            inMessage.setHeader(key, value);
            LOG.debug("Populate exchange from Restlet request header: {} value: {}", (Object)key, value);
        }
        String query = request.getResourceRef().getQuery();
        if (query != null) {
            inMessage.setHeader("CamelHttpQuery", (Object)query);
        }
        inMessage.setHeader("CamelHttpUri", (Object)request.getResourceRef().getIdentifier(true));
        inMessage.setHeader("CamelHttpMethod", (Object)request.getMethod().toString());
        if (!request.isEntityAvailable()) {
            return;
        }
        if (request.getEntity().getMediaType() != null && request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
            Form form = new Form(request.getEntity());
            for (Map.Entry entry : form.getValuesMap().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) {
                    inMessage.setBody((Object)key);
                    LOG.debug("Populate exchange from Restlet request body: {}", (Object)key);
                    continue;
                }
                if (this.headerFilterStrategy.applyFilterToExternalHeaders(key, (Object)value, exchange)) continue;
                inMessage.setHeader(key, (Object)value);
                LOG.debug("Populate exchange from Restlet request user header: {} value: {}", (Object)key, (Object)value);
            }
        } else {
            inMessage.setBody((Object)request.getEntity().getStream());
        }
    }

    @Override
    public void populateRestletRequestFromExchange(Request request, Exchange exchange) {
        request.setReferrerRef("camel-restlet");
        String body = (String)exchange.getIn().getBody(String.class);
        Form form = new Form();
        form.add(body, null);
        MediaType mediaType = (MediaType)exchange.getIn().getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_WWW_FORM;
        }
        LOG.debug("Populate Restlet request from exchange body: {} using media type {}", (Object)body, (Object)mediaType);
        String login = (String)exchange.getIn().getHeader("CamelRestletLogin", String.class);
        String password = (String)exchange.getIn().getHeader("CamelRestletPassword", String.class);
        if (login != null && password != null) {
            ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password);
            request.setChallengeResponse(authentication);
            LOG.debug("Basic HTTP Authentication has been applied");
        }
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(key, value = entry.getValue(), exchange)) continue;
            if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
                if (key.startsWith("org.restlet.")) {
                    request.getAttributes().put(key, value);
                } else {
                    form.add(key, value.toString());
                }
            } else {
                request.getAttributes().put(key, value);
            }
            LOG.debug("Populate Restlet request from exchange header: {} value: {}", (Object)key, value);
        }
        LOG.debug("Using Content Type: {} for POST data: {}", (Object)mediaType, (Object)body);
        if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
            request.setEntity(form.getWebRepresentation());
        } else {
            request.setEntity(body, mediaType);
        }
        MediaType acceptedMediaType = (MediaType)exchange.getIn().getHeader("CamelAcceptContentType", MediaType.class);
        if (acceptedMediaType != null) {
            request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)acceptedMediaType));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateRestletResponseFromExchange(Exchange exchange, Response response) throws Exception {
        Object body;
        Integer responseCode;
        Message out;
        block22: {
            if (exchange.isFailed()) {
                response.setStatus(Status.valueOf((int)500));
                if (exchange.hasOut() && exchange.getOut().isFault()) {
                    out = exchange.getOut();
                    break block22;
                } else {
                    Exception t = exchange.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    response.setEntity(sw.toString(), MediaType.TEXT_PLAIN);
                    return;
                }
            }
            out = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        }
        MediaType mediaType = (MediaType)out.getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            Object body2 = out.getBody();
            mediaType = MediaType.TEXT_PLAIN;
            if (body2 instanceof String) {
                mediaType = MediaType.TEXT_PLAIN;
            } else if (body2 instanceof StringSource || body2 instanceof DOMSource) {
                mediaType = MediaType.TEXT_XML;
            }
        }
        if ((responseCode = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            response.setStatus(Status.valueOf((int)responseCode));
        }
        if ((body = out.getBody()) instanceof WrappedFile) {
            GenericFile gf = (GenericFile)body;
            body = gf.getBody();
        }
        if (body == null) {
            response.setEntity("", MediaType.TEXT_PLAIN);
        } else if (body instanceof Response) {
            LOG.debug("Using existing Restlet Response from exchange body: {}", body);
        } else if (body instanceof Representation) {
            response.setEntity((Representation)out.getBody(Representation.class));
        } else if (body instanceof InputStream) {
            response.setEntity((Representation)new InputRepresentation((InputStream)out.getBody(InputStream.class), mediaType));
        } else if (body instanceof File) {
            response.setEntity((Representation)new FileRepresentation((File)out.getBody(File.class), mediaType));
        } else {
            String text = (String)out.getBody(String.class);
            response.setEntity(text, mediaType);
        }
        LOG.debug("Populate Restlet response from exchange body: {}", body);
        if (exchange.getProperty("CamelCharsetName") != null) {
            CharacterSet cs = CharacterSet.valueOf((String)((String)exchange.getProperty("CamelCharsetName", String.class)));
            response.getEntity().setCharacterSet(cs);
        }
        Iterator i$ = out.getHeaders().entrySet().iterator();
        while (i$.hasNext()) {
            Object value;
            Map.Entry entry = i$.next();
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(key, value = entry.getValue(), exchange)) continue;
            this.setResponseHeader(exchange, (org.restlet.Message)response, key, value);
            LOG.debug("Populate Restlet HTTP header in response from exchange header: {} value: {}", (Object)key, value);
        }
        return;
    }

    @Override
    public void populateExchangeFromRestletResponse(Exchange exchange, Response response) throws Exception {
        for (Map.Entry entry : response.getAttributes().entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(key, value = entry.getValue(), exchange)) continue;
            exchange.getOut().setHeader(key, value);
            LOG.debug("Populate exchange from Restlet response header: {} value: {}", (Object)key, value);
        }
        int responseCode = response.getStatus().getCode();
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        exchange.getOut().setHeader("CamelRestletResponse", (Object)response);
        if (response.getEntity() != null) {
            MediaType mediaType = response.getEntity().getMediaType();
            if (mediaType != null) {
                exchange.getOut().setHeader("Content-Type", (Object)mediaType.toString());
            }
            String text = response.getEntity().getText();
            LOG.debug("Populate exchange from Restlet response: {}", (Object)text);
            exchange.getOut().setBody((Object)text);
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)false);
    }

    protected void setResponseHeader(Exchange exchange, org.restlet.Message message, String header, Object value) {
        message.getAttributes().put(header, value);
        if (value == null) {
            return;
        }
        if (message.getEntity() != null) {
            Date date;
            SimpleDateFormat format;
            if (header.equalsIgnoreCase("Cache-Control")) {
                if (value instanceof List) {
                    message.setCacheDirectives((List)value);
                }
                if (value instanceof String) {
                    ArrayList<CacheDirective> list = new ArrayList<CacheDirective>();
                    list.add(new CacheDirective((String)value));
                    message.setCacheDirectives(list);
                }
            }
            if (header.equalsIgnoreCase("Expires")) {
                if (value instanceof Calendar) {
                    message.getEntity().setExpirationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setExpirationDate((Date)value);
                } else if (value instanceof String) {
                    format = new SimpleDateFormat(RFC_2822_DATE_PATTERN, Locale.ENGLISH);
                    try {
                        date = format.parse((String)value);
                        message.getEntity().setExpirationDate(date);
                    }
                    catch (ParseException e) {
                        LOG.debug("Header {} with value {} cannot be converted as a Date. The value will be ignored.", (Object)"Expires", value);
                    }
                }
            }
            if (header.equalsIgnoreCase("Last-Modified")) {
                if (value instanceof Calendar) {
                    message.getEntity().setModificationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setModificationDate((Date)value);
                } else if (value instanceof String) {
                    format = new SimpleDateFormat(RFC_2822_DATE_PATTERN, Locale.ENGLISH);
                    try {
                        date = format.parse((String)value);
                        message.getEntity().setModificationDate(date);
                    }
                    catch (ParseException e) {
                        LOG.debug("Header {} with value {} cannot be converted as a Date. The value will be ignored.", (Object)"Last-Modified", value);
                    }
                }
            }
            if (header.equalsIgnoreCase("Content-Length")) {
                if (value instanceof Long) {
                    message.getEntity().setSize(((Long)value).longValue());
                } else if (value instanceof Integer) {
                    message.getEntity().setSize((long)((Integer)value).intValue());
                } else {
                    Long num = (Long)exchange.getContext().getTypeConverter().tryConvertTo(Long.class, value);
                    if (num != null) {
                        message.getEntity().setSize(num.longValue());
                    } else {
                        LOG.debug("Header {} with value {} cannot be converted as a Long. The value will be ignored.", (Object)"Content-Length", value);
                    }
                }
            }
            if (header.equalsIgnoreCase("Content-Type")) {
                if (value instanceof MediaType) {
                    message.getEntity().setMediaType((MediaType)value);
                } else {
                    String type = value.toString();
                    MediaType media = MediaType.valueOf((String)type);
                    if (media != null) {
                        message.getEntity().setMediaType(media);
                    } else {
                        LOG.debug("Header {} with value {} cannot be converted as a MediaType. The value will be ignored.", (Object)"Content-Type", value);
                    }
                }
            }
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

