/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.restlet.DefaultRestletBinding;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletHeaderFilterStrategy;
import org.apache.camel.component.restlet.RestletProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.restlet.data.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private Method restletMethod = Method.GET;
    private Method[] restletMethods;
    private String protocol = "http";
    private String host = "localhost";
    private int port = 80;
    private String uriPattern;
    private List<String> restletUriPatterns;
    private Map<String, String> restletRealm;
    private HeaderFilterStrategy headerFilterStrategy;
    private RestletBinding restletBinding;

    public RestletEndpoint(RestletComponent component, String remaining) throws Exception {
        super(remaining, (Component)component);
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new RestletConsumer((Endpoint)this, processor);
    }

    public Producer createProducer() throws Exception {
        return new RestletProducer(this);
    }

    public void connect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).connect(restletConsumer);
    }

    public void disconnect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).disconnect(restletConsumer);
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    public void setRestletMethod(Method restletMethod) {
        this.restletMethod = restletMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public RestletBinding getRestletBinding() {
        return this.restletBinding;
    }

    public void setRestletBinding(RestletBinding restletBinding) {
        this.restletBinding = restletBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.restletBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.restletBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setRestletRealm(Map<String, String> restletRealm) {
        this.restletRealm = restletRealm;
    }

    public Map<String, String> getRestletRealm() {
        return this.restletRealm;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public void setRestletMethods(Method[] restletMethods) {
        this.restletMethods = restletMethods;
    }

    public Method[] getRestletMethods() {
        return this.restletMethods;
    }

    public void setRestletUriPatterns(List<String> restletUriPatterns) {
        this.restletUriPatterns = restletUriPatterns;
    }

    public List<String> getRestletUriPatterns() {
        return this.restletUriPatterns;
    }

    public void start() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new RestletHeaderFilterStrategy();
        }
        if (this.restletBinding == null) {
            this.restletBinding = new DefaultRestletBinding();
        }
        if (this.restletBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.restletBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    public void stop() throws Exception {
    }
}

