/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StringSource;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestletBinding
implements RestletBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestletBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateExchangeFromRestletRequest(Request request, Response response, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        inMessage.setHeader("CamelRestletRequest", (Object)request);
        inMessage.setHeader("CamelRestletResponse", (Object)response);
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            inMessage.setHeader((String)entry.getKey(), entry.getValue());
            LOG.debug("Populate exchange from Restlet request header: {} value: {}", entry.getKey(), entry.getValue());
        }
        String query = request.getResourceRef().getQuery();
        if (query != null) {
            inMessage.setHeader("CamelHttpQuery", (Object)query);
        }
        inMessage.setHeader("CamelHttpUri", (Object)request.getResourceRef().getIdentifier(true));
        inMessage.setHeader("CamelHttpMethod", (Object)request.getMethod().toString());
        if (!request.isEntityAvailable()) {
            return;
        }
        if (request.getEntity().getMediaType() != null && request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
            Form form = new Form(request.getEntity());
            for (Map.Entry entry : form.getValuesMap().entrySet()) {
                if (entry.getValue() == null) {
                    inMessage.setBody(entry.getKey());
                    LOG.debug("Populate exchange from Restlet request body: {}", entry.getValue());
                    continue;
                }
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                inMessage.setHeader((String)entry.getKey(), entry.getValue());
                LOG.debug("Populate exchange from Restlet request user header: {} value: {}", entry.getKey(), entry.getValue());
            }
        } else {
            inMessage.setBody((Object)request.getEntity().getStream());
        }
    }

    @Override
    public void populateRestletRequestFromExchange(Request request, Exchange exchange) {
        request.setReferrerRef("camel-restlet");
        String body = (String)exchange.getIn().getBody(String.class);
        Form form = new Form();
        form.add(body, null);
        MediaType mediaType = (MediaType)exchange.getIn().getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_WWW_FORM;
        }
        LOG.debug("Populate Restlet request from exchange body: {} using media type {}", (Object)body, (Object)mediaType);
        String login = (String)exchange.getIn().getHeader("CamelRestletLogin", String.class);
        String password = (String)exchange.getIn().getHeader("CamelRestletPassword", String.class);
        if (login != null && password != null) {
            ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password);
            request.setChallengeResponse(authentication);
            LOG.debug("Basic HTTP Authentication has been applied");
        }
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
                if (((String)entry.getKey()).startsWith("org.restlet.")) {
                    request.getAttributes().put(entry.getKey(), entry.getValue());
                } else {
                    form.add((String)entry.getKey(), entry.getValue().toString());
                }
            } else {
                request.getAttributes().put(entry.getKey(), entry.getValue());
            }
            LOG.debug("Populate Restlet request from exchange header: {} value: {}", entry.getKey(), entry.getValue());
        }
        LOG.debug("Using Content Type: {} for POST data: {}", (Object)mediaType, (Object)body);
        if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
            request.setEntity(form.getWebRepresentation());
        } else {
            request.setEntity(body, mediaType);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateRestletResponseFromExchange(Exchange exchange, Response response) {
        Integer responseCode;
        Message out;
        block19: {
            if (exchange.isFailed()) {
                response.setStatus(Status.valueOf((int)500));
                if (exchange.hasOut() && exchange.getOut().isFault()) {
                    out = exchange.getOut();
                    break block19;
                } else {
                    Exception t = exchange.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    response.setEntity(sw.toString(), MediaType.TEXT_PLAIN);
                    return;
                }
            }
            out = exchange.getOut();
        }
        MediaType mediaType = (MediaType)out.getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            Object body = out.getBody();
            mediaType = MediaType.TEXT_PLAIN;
            if (body instanceof String) {
                mediaType = MediaType.TEXT_PLAIN;
            } else if (body instanceof StringSource || body instanceof DOMSource) {
                mediaType = MediaType.TEXT_XML;
            }
        }
        if ((responseCode = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            response.setStatus(Status.valueOf((int)responseCode));
        }
        for (Map.Entry entry : out.getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            response.getAttributes().put(entry.getKey(), entry.getValue());
            LOG.debug("Populate Restlet response from exchange header: {} value: {}", entry.getKey(), entry.getValue());
        }
        Object body = out.getBody();
        if (body instanceof WrappedFile) {
            GenericFile gf = (GenericFile)body;
            body = gf.getBody();
        }
        if (body == null) {
            response.setEntity("", MediaType.TEXT_PLAIN);
        } else if (body instanceof Response) {
            LOG.debug("Using existing Restlet Response from exchange body: {}", body);
        } else if (body instanceof InputStream) {
            response.setEntity((Representation)new InputRepresentation((InputStream)out.getBody(InputStream.class), mediaType));
        } else if (body instanceof File) {
            response.setEntity((Representation)new FileRepresentation((File)out.getBody(File.class), mediaType));
        } else {
            String text = (String)out.getBody(String.class);
            response.setEntity(text, mediaType);
        }
        LOG.debug("Populate Restlet response from exchange body: {}", body);
        if (exchange.getProperty("CamelCharsetName") != null) {
            CharacterSet cs = CharacterSet.valueOf((String)((String)exchange.getProperty("CamelCharsetName", String.class)));
            response.getEntity().setCharacterSet(cs);
        }
    }

    @Override
    public void populateExchangeFromRestletResponse(Exchange exchange, Response response) throws Exception {
        for (Map.Entry entry : response.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            exchange.getOut().setHeader((String)entry.getKey(), entry.getValue());
            LOG.debug("Populate exchange from Restlet response header: {} value: {}", entry.getKey(), entry.getValue());
        }
        int responseCode = response.getStatus().getCode();
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        exchange.getOut().setHeader("CamelRestletResponse", (Object)response);
        if (response.getEntity() != null) {
            MediaType mediaType = response.getEntity().getMediaType();
            if (mediaType != null) {
                exchange.getOut().setHeader("Content-Type", (Object)mediaType.toString());
            }
            String text = response.getEntity().getText();
            LOG.debug("Populate exchange from Restlet response: {}", (Object)text);
            exchange.getOut().setBody((Object)text);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

