/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.restlet.MethodBasedRouter;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletComponent
extends HeaderFilterStrategyComponent {
    private static final Logger LOG = LoggerFactory.getLogger(RestletComponent.class);
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, MethodBasedRouter> routers = new HashMap<String, MethodBasedRouter>();
    private final Component component;
    private Boolean controllerDaemon;
    private Integer controllerSleepTimeMs;
    private Integer inboundBufferSize;
    private Integer minThreads;
    private Integer maxThreads;
    private Integer maxConnectionsPerHost;
    private Integer maxTotalConnections;
    private Integer outboundBufferSize;
    private Boolean persistingConnections;
    private Boolean pipeliningConnections;
    private Integer threadMaxIdleTimeMs;
    private Boolean useForwardedForHeader;

    public RestletComponent() {
        this(new Component());
    }

    public RestletComponent(Component component) {
        this.component = component;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        RestletEndpoint result = new RestletEndpoint(this, remaining);
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Object)result, parameters);
        result.updateEndpointUri();
        URI u = new URI(remaining);
        String protocol = u.getScheme();
        String uriPattern = u.getPath();
        if (parameters.size() > 0) {
            uriPattern = uriPattern + "?" + URISupport.createQueryString((Map)parameters);
        }
        int port = 0;
        String host = u.getHost();
        if (u.getPort() > 0) {
            port = u.getPort();
        }
        result.setProtocol(protocol);
        result.setUriPattern(uriPattern);
        result.setHost(host);
        if (port > 0) {
            result.setPort(port);
        }
        return result;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.component.start();
    }

    protected void doStop() throws Exception {
        this.component.stop();
        super.doStop();
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public void connect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = consumer.getEndpoint();
        this.addServerIfNecessary(endpoint);
        if (endpoint.getUriPattern() != null && endpoint.getUriPattern().length() > 0) {
            this.attachUriPatternToRestlet(endpoint.getUriPattern(), endpoint, consumer.getRestlet());
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                this.attachUriPatternToRestlet(uriPattern, endpoint, consumer.getRestlet());
            }
        }
    }

    public void disconnect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = consumer.getEndpoint();
        ArrayList<MethodBasedRouter> routers = new ArrayList<MethodBasedRouter>();
        String pattern = RestletComponent.decodePattern(endpoint.getUriPattern());
        if (pattern != null && !pattern.isEmpty()) {
            routers.add(this.getMethodRouter(pattern));
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                routers.add(this.getMethodRouter(uriPattern));
            }
        }
        for (MethodBasedRouter router : routers) {
            if (endpoint.getRestletMethods() != null) {
                Method[] methods;
                for (Method method : methods = endpoint.getRestletMethods()) {
                    router.removeRoute(method);
                }
            } else {
                router.removeRoute(endpoint.getRestletMethod());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Detached restlet uriPattern: {} method: {}", (Object)router.getUriPattern(), (Object)endpoint.getRestletMethod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBasedRouter getMethodRouter(String uriPattern) {
        Map<String, MethodBasedRouter> map = this.routers;
        synchronized (map) {
            MethodBasedRouter result = this.routers.get(uriPattern);
            if (result == null) {
                result = new MethodBasedRouter(uriPattern);
                LOG.debug("Added method based router: {}", (Object)result);
                this.routers.put(uriPattern, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerIfNecessary(RestletEndpoint endpoint) throws Exception {
        String key = RestletComponent.buildKey(endpoint);
        Map<String, Server> map = this.servers;
        synchronized (map) {
            Server server = this.servers.get(key);
            if (server == null) {
                server = this.component.getServers().add(Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getPort());
                Series params = server.getContext().getParameters();
                if (this.getControllerDaemon() != null) {
                    params.add("controllerDaemon", this.getControllerDaemon().toString());
                }
                if (this.getControllerSleepTimeMs() != null) {
                    params.add("controllerSleepTimeMs", this.getControllerSleepTimeMs().toString());
                }
                if (this.getInboundBufferSize() != null) {
                    params.add("inboundBufferSize", this.getInboundBufferSize().toString());
                }
                if (this.getMinThreads() != null) {
                    params.add("minThreads", this.getMinThreads().toString());
                }
                if (this.getMaxThreads() != null) {
                    params.add("maxThreads", this.getMaxThreads().toString());
                }
                if (this.getMaxConnectionsPerHost() != null) {
                    params.add("maxConnectionsPerHost", this.getMaxConnectionsPerHost().toString());
                }
                if (this.getMaxTotalConnections() != null) {
                    params.add("maxTotalConnections", this.getMaxTotalConnections().toString());
                }
                if (this.getOutboundBufferSize() != null) {
                    params.add("outboundBufferSize", this.getOutboundBufferSize().toString());
                }
                if (this.getPersistingConnections() != null) {
                    params.add("persistingConnections", this.getPersistingConnections().toString());
                }
                if (this.getPipeliningConnections() != null) {
                    params.add("pipeliningConnections", this.getPipeliningConnections().toString());
                }
                if (this.getThreadMaxIdleTimeMs() != null) {
                    params.add("threadMaxIdleTimeMs", this.getThreadMaxIdleTimeMs().toString());
                }
                if (this.getUseForwardedForHeader() != null) {
                    params.add("useForwardedForHeader", this.getUseForwardedForHeader().toString());
                }
                LOG.debug("Setting parameters: {} to server: {}", (Object)params, (Object)server);
                server.getContext().setParameters(params);
                this.servers.put(key, server);
                LOG.debug("Added server: {}", (Object)key);
                server.start();
            }
        }
    }

    private static String buildKey(RestletEndpoint endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void attachUriPatternToRestlet(String uriPattern, RestletEndpoint endpoint, Restlet target) {
        uriPattern = RestletComponent.decodePattern(uriPattern);
        MethodBasedRouter router = this.getMethodRouter(uriPattern);
        Map<String, String> realm = endpoint.getRestletRealm();
        if (realm != null && realm.size() > 0) {
            ChallengeAuthenticator guard = new ChallengeAuthenticator(this.component.getContext().createChildContext(), ChallengeScheme.HTTP_BASIC, "Camel-Restlet Endpoint Realm");
            MapVerifier verifier = new MapVerifier();
            for (Map.Entry<String, String> entry : realm.entrySet()) {
                verifier.getLocalSecrets().put(entry.getKey(), entry.getValue().toCharArray());
            }
            guard.setVerifier((Verifier)verifier);
            guard.setNext(target);
            target = guard;
            LOG.debug("Target has been set to guard: {}", (Object)guard);
        }
        if (endpoint.getRestletMethods() != null) {
            Method[] methods;
            for (Method method : methods = endpoint.getRestletMethods()) {
                router.addRoute(method, target);
                LOG.debug("Attached restlet uriPattern: {} method: {}", (Object)uriPattern, (Object)method);
            }
        } else {
            router.addRoute(endpoint.getRestletMethod(), target);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attached restlet uriPattern: {} method: {}", (Object)uriPattern, (Object)endpoint.getRestletMethod());
            }
        }
        if (!router.hasBeenAttached()) {
            this.component.getDefaultHost().attach(uriPattern, (Restlet)router);
            LOG.debug("Attached methodRouter uriPattern: {}", (Object)uriPattern);
        }
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        return UnsafeUriCharactersEncoder.encode((String)uri.replaceAll("%7B", "(").replaceAll("%7D", ")"));
    }

    private static String decodePattern(String pattern) {
        return pattern == null ? null : pattern.replaceAll("\\(", "{").replaceAll("\\)", "}");
    }

    public Boolean getControllerDaemon() {
        return this.controllerDaemon;
    }

    public void setControllerDaemon(Boolean controllerDaemon) {
        this.controllerDaemon = controllerDaemon;
    }

    public Integer getControllerSleepTimeMs() {
        return this.controllerSleepTimeMs;
    }

    public void setControllerSleepTimeMs(Integer controllerSleepTimeMs) {
        this.controllerSleepTimeMs = controllerSleepTimeMs;
    }

    public Integer getInboundBufferSize() {
        return this.inboundBufferSize;
    }

    public void setInboundBufferSize(Integer inboundBufferSize) {
        this.inboundBufferSize = inboundBufferSize;
    }

    public Integer getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getOutboundBufferSize() {
        return this.outboundBufferSize;
    }

    public void setOutboundBufferSize(Integer outboundBufferSize) {
        this.outboundBufferSize = outboundBufferSize;
    }

    public Boolean getPersistingConnections() {
        return this.persistingConnections;
    }

    public void setPersistingConnections(Boolean persistingConnections) {
        this.persistingConnections = persistingConnections;
    }

    public Boolean getPipeliningConnections() {
        return this.pipeliningConnections;
    }

    public void setPipeliningConnections(Boolean pipeliningConnections) {
        this.pipeliningConnections = pipeliningConnections;
    }

    public Integer getThreadMaxIdleTimeMs() {
        return this.threadMaxIdleTimeMs;
    }

    public void setThreadMaxIdleTimeMs(Integer threadMaxIdleTimeMs) {
        this.threadMaxIdleTimeMs = threadMaxIdleTimeMs;
    }

    public Boolean getUseForwardedForHeader() {
        return this.useForwardedForHeader;
    }

    public void setUseForwardedForHeader(Boolean useForwardedForHeader) {
        this.useForwardedForHeader = useForwardedForHeader;
    }
}

