/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.processor.BulkApiProcessor;
import org.apache.camel.component.salesforce.internal.processor.JsonRestProcessor;
import org.apache.camel.component.salesforce.internal.processor.SalesforceProcessor;
import org.apache.camel.component.salesforce.internal.processor.XmlRestProcessor;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ServiceHelper;

public class SalesforceProducer
extends DefaultAsyncProducer {
    private final SalesforceProcessor processor;

    public SalesforceProducer(SalesforceEndpoint endpoint) throws SalesforceException {
        super((Endpoint)endpoint);
        SalesforceEndpointConfig endpointConfig = endpoint.getConfiguration();
        PayloadFormat payloadFormat = endpointConfig.getFormat();
        this.processor = this.isBulkOperation(endpoint.getOperationName()) ? new BulkApiProcessor(endpoint) : (payloadFormat == PayloadFormat.JSON ? new JsonRestProcessor(endpoint) : new XmlRestProcessor(endpoint));
    }

    private boolean isBulkOperation(OperationName operationName) {
        switch (operationName) {
            case CREATE_JOB: 
            case GET_JOB: 
            case CLOSE_JOB: 
            case ABORT_JOB: 
            case CREATE_BATCH: 
            case GET_BATCH: 
            case GET_ALL_BATCHES: 
            case GET_REQUEST: 
            case GET_RESULTS: 
            case CREATE_BATCH_QUERY: 
            case GET_QUERY_RESULT_IDS: 
            case GET_QUERY_RESULT: {
                return true;
            }
        }
        return false;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.log.debug("Processing {}", (Object)((SalesforceEndpoint)this.getEndpoint()).getOperationName());
        return this.processor.process(exchange, callback);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
        super.doStop();
    }
}

