/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SalesforceExchange;
import org.apache.camel.component.salesforce.internal.dto.RestErrors;
import org.apache.camel.util.URISupport;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.util.StringUtil;

public class DefaultRestClient
extends AbstractClientBase
implements RestClient {
    private static final String SERVICES_DATA = "/services/data/";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String SERVICES_APEXREST = "/services/apexrest/";
    protected PayloadFormat format;
    private ObjectMapper objectMapper;
    private XStream xStream;

    public DefaultRestClient(HttpClient httpClient, String version, PayloadFormat format, SalesforceSession session) throws SalesforceException {
        super(version, session, httpClient);
        this.format = format;
        this.objectMapper = new ObjectMapper();
        this.xStream = new XStream();
        this.xStream.processAnnotations(RestErrors.class);
    }

    @Override
    protected void doHttpRequest(ContentExchange request, AbstractClientBase.ClientResponseCallback callback) {
        String contentType = PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8";
        request.setRequestHeader("Accept", contentType);
        request.setRequestHeader("Accept-Charset", "UTF-8");
        super.doHttpRequest(request, callback);
    }

    @Override
    protected SalesforceException createRestException(ContentExchange httpExchange) {
        try {
            if (PayloadFormat.JSON.equals((Object)this.format)) {
                List restErrors = (List)this.objectMapper.readValue(httpExchange.getResponseContent(), (TypeReference)new TypeReference<List<RestError>>(){});
                return new SalesforceException(restErrors, httpExchange.getResponseStatus());
            }
            RestErrors errors = new RestErrors();
            this.xStream.fromXML(httpExchange.getResponseContent(), (Object)errors);
            return new SalesforceException(errors.getErrors(), httpExchange.getResponseStatus());
        }
        catch (IOException e) {
            String msg = "Unexpected Error parsing " + (Object)((Object)this.format) + " error response: " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        catch (RuntimeException e) {
            String msg = "Unexpected Error parsing " + (Object)((Object)this.format) + " error response: " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        return new SalesforceException("Unexpected error", httpExchange.getResponseStatus());
    }

    @Override
    public void getVersions(RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.servicesDataUrl());
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getResources(RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.versionUrl());
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getGlobalObjects(RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsUrl(""));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBasicInfo(String sObjectName, RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsUrl(sObjectName + "/"));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getDescription(String sObjectName, RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsUrl(sObjectName + "/describe/"));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObject(String sObjectName, String id, String[] fields, RestClient.ResponseCallback callback) {
        String params = "";
        if (fields != null && fields.length > 0) {
            StringBuilder fieldsValue = new StringBuilder("?fields=");
            for (int i = 0; i < fields.length; ++i) {
                fieldsValue.append(fields[i]);
                if (i >= fields.length - 1) continue;
                fieldsValue.append(',');
            }
            params = fieldsValue.toString();
        }
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsUrl(sObjectName + "/" + id + params));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void createSObject(String sObjectName, InputStream sObject, RestClient.ResponseCallback callback) {
        SalesforceExchange post = this.getContentExchange("POST", this.sobjectsUrl(sObjectName));
        this.setAccessToken((HttpExchange)post);
        post.setRequestContentSource(sObject);
        post.setRequestContentType(PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8");
        this.doHttpRequest(post, new DelegatingClientCallback(callback));
    }

    @Override
    public void updateSObject(String sObjectName, String id, InputStream sObject, RestClient.ResponseCallback callback) {
        SalesforceExchange patch = this.getContentExchange("PATCH", this.sobjectsUrl(sObjectName + "/" + id));
        this.setAccessToken((HttpExchange)patch);
        patch.setRequestContentSource(sObject);
        patch.setRequestContentType(PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8");
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObject(String sObjectName, String id, RestClient.ResponseCallback callback) {
        SalesforceExchange delete = this.getContentExchange("DELETE", this.sobjectsUrl(sObjectName + "/" + id));
        this.setAccessToken((HttpExchange)delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObjectWithId(String sObjectName, String fieldName, String fieldValue, RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void upsertSObject(String sObjectName, String fieldName, String fieldValue, InputStream sObject, RestClient.ResponseCallback callback) {
        SalesforceExchange patch = this.getContentExchange("PATCH", this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken((HttpExchange)patch);
        patch.setRequestContentSource(sObject);
        patch.setRequestContentType(PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8");
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObjectWithId(String sObjectName, String fieldName, String fieldValue, RestClient.ResponseCallback callback) {
        SalesforceExchange delete = this.getContentExchange("DELETE", this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken((HttpExchange)delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBlobField(String sObjectName, String id, String blobFieldName, RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.sobjectsUrl(sObjectName + "/" + id + "/" + blobFieldName));
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void query(String soqlQuery, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soqlQuery);
            SalesforceExchange get = this.getContentExchange("GET", this.versionUrl() + "query/?q=" + encodedQuery);
            this.setAccessToken((HttpExchange)get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    @Override
    public void queryMore(String nextRecordsUrl, RestClient.ResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.instanceUrl + nextRecordsUrl);
        this.setAccessToken((HttpExchange)get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void search(String soslQuery, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soslQuery);
            SalesforceExchange get = this.getContentExchange("GET", this.versionUrl() + "search/?q=" + encodedQuery);
            this.setAccessToken((HttpExchange)get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    @Override
    public void apexCall(String httpMethod, String apexUrl, Map<String, Object> queryParams, InputStream requestDto, RestClient.ResponseCallback callback) {
        try {
            SalesforceExchange exchange = this.getContentExchange(httpMethod, this.apexCallUrl(apexUrl, queryParams));
            if (requestDto != null) {
                exchange.setRequestContentSource(requestDto);
                exchange.setRequestContentType(PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8");
            }
            this.setAccessToken((HttpExchange)exchange);
            this.doHttpRequest(exchange, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
        catch (URISyntaxException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    private String apexCallUrl(String apexUrl, Map<String, Object> queryParams) throws UnsupportedEncodingException, URISyntaxException {
        if (queryParams != null && !queryParams.isEmpty()) {
            apexUrl = URISupport.appendParametersToURI((String)apexUrl, queryParams);
        }
        return this.instanceUrl + SERVICES_APEXREST + apexUrl;
    }

    private String servicesDataUrl() {
        return this.instanceUrl + SERVICES_DATA;
    }

    private String versionUrl() {
        if (this.version == null) {
            throw new IllegalArgumentException("NULL API version", new NullPointerException("version"));
        }
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    private String sobjectsUrl(String sObjectName) {
        if (sObjectName == null) {
            throw new IllegalArgumentException("Null SObject name", new NullPointerException("sObjectName"));
        }
        return this.versionUrl() + "sobjects/" + sObjectName;
    }

    private String sobjectsExternalIdUrl(String sObjectName, String fieldName, String fieldValue) {
        if (fieldName == null || fieldValue == null) {
            throw new IllegalArgumentException("External field name and value cannot be NULL");
        }
        try {
            String encodedValue = this.urlEncode(fieldValue);
            return this.sobjectsUrl(sObjectName + "/" + fieldName + "/" + encodedValue);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    protected void setAccessToken(HttpExchange httpExchange) {
        httpExchange.setRequestHeader(TOKEN_HEADER, TOKEN_PREFIX + this.accessToken);
    }

    private String urlEncode(String query) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(query, StringUtil.__UTF8_CHARSET.toString());
        encodedQuery = encodedQuery.replace("+", "%20");
        return encodedQuery;
    }

    private static class DelegatingClientCallback
    implements AbstractClientBase.ClientResponseCallback {
        private final RestClient.ResponseCallback callback;

        public DelegatingClientCallback(RestClient.ResponseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(InputStream response, SalesforceException ex) {
            this.callback.onResponse(response, ex);
        }
    }
}

