/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.IOException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.SalesforceExchange;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceSecurityListener
extends HttpEventListenerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSecurityListener.class);
    private final HttpDestination destination;
    private final HttpExchange exchange;
    private final SalesforceSession session;
    private String currentToken;
    private int retries;
    private boolean retrying;
    private boolean requestComplete;
    private boolean responseComplete;

    public SalesforceSecurityListener(HttpDestination destination, HttpExchange exchange, SalesforceSession session, String accessToken) {
        super(exchange.getEventListener(), true);
        this.destination = destination;
        this.exchange = exchange;
        this.session = session;
        this.currentToken = accessToken;
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (status == 401 && this.retries < this.destination.getHttpClient().maxRetries()) {
            LOG.warn("Retrying on Salesforce authentication error [{}]: [{}]", (Object)status, (Object)reason);
            this.setDelegatingRequests(false);
            this.setDelegatingResponses(false);
            this.retrying = true;
        }
        super.onResponseStatus(version, status, reason);
    }

    public void onRequestComplete() throws IOException {
        this.requestComplete = true;
        if (this.checkExchangeComplete()) {
            super.onRequestComplete();
        }
    }

    public void onResponseComplete() throws IOException {
        this.responseComplete = true;
        if (this.checkExchangeComplete()) {
            super.onResponseComplete();
        }
    }

    private boolean checkExchangeComplete() throws IOException {
        if (this.retrying && this.requestComplete && this.responseComplete) {
            LOG.debug("Authentication Error, retrying: {}", (Object)this.exchange);
            this.requestComplete = false;
            this.responseComplete = false;
            this.setDelegatingRequests(true);
            this.setDelegatingResponses(true);
            try {
                this.currentToken = this.session.login(this.currentToken);
                if (this.exchange instanceof SalesforceExchange) {
                    SalesforceExchange salesforceExchange = (SalesforceExchange)this.exchange;
                    AbstractClientBase client = salesforceExchange.getClient();
                    client.setAccessToken(this.currentToken);
                    client.setInstanceUrl(this.session.getInstanceUrl());
                    client.setAccessToken(this.exchange);
                } else {
                    this.exchange.setRequestHeader("Authorization", "OAuth " + this.currentToken);
                }
                this.destination.resend(this.exchange);
                return false;
            }
            catch (SalesforceException e) {
                LOG.error(e.getMessage(), (Throwable)((Object)e));
                this.setDelegationResult(false);
            }
        }
        return true;
    }

    public void onRetry() {
        if (this.retrying) {
            this.retrying = false;
            ++this.retries;
            this.setDelegatingRequests(true);
            this.setDelegatingResponses(true);
            this.requestComplete = false;
            this.responseComplete = false;
        }
        super.onRetry();
    }

    public void onConnectionFailed(Throwable ex) {
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        super.onConnectionFailed(ex);
    }

    public void onException(Throwable ex) {
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        super.onException(ex);
    }
}

