/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.client.RestClient;

public class SyncResponseCallback
implements RestClient.ResponseCallback {
    private InputStream response;
    private SalesforceException exception;
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onResponse(InputStream response, SalesforceException exception) {
        this.response = response;
        this.exception = exception;
        this.latch.countDown();
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
    }

    public boolean await(long duration, TimeUnit unit) throws InterruptedException {
        return this.latch.await(duration, unit);
    }

    public InputStream getResponse() {
        return this.response;
    }

    public SalesforceException getException() {
        return this.exception;
    }
}

