/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.salesforce.springboot;

import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The salesforce component is used for integrating Camel with the massive
 * Salesforce API.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.salesforce")
public class SalesforceComponentConfiguration {

    /**
     * To use the shared SalesforceLoginConfig as login configuration.
     * Properties of the shared configuration can also be set individually.
     */
    private SalesforceLoginConfig loginConfig;
    /**
     * To use the shared SalesforceEndpointConfig as configuration. Properties
     * of the shared configuration can also be set individually.
     */
    private SalesforceEndpointConfig config;
    /**
     * Used for configuring HTTP client properties as key/value pairs
     */
    private Map<String, Object> httpClientProperties;
    /**
     * To configure security using SSLContextParameters
     */
    private SSLContextParameters sslContextParameters;
    /**
     * To configure HTTP proxy host
     */
    private String httpProxyHost;
    /**
     * To configure HTTP proxy port
     */
    private Integer httpProxyPort;
    /**
     * To configure HTTP proxy username
     */
    private String httpProxyUsername;
    /**
     * To configure HTTP proxy password
     */
    private String httpProxyPassword;
    /**
     * Enable for Socks4 proxy false by default
     */
    private Boolean isHttpProxySocks4;
    /**
     * Enable for TLS connections true by default
     */
    private Boolean isHttpProxySecure;
    /**
     * HTTP proxy included addresses
     */
    private Set<String> httpProxyIncludedAddresses;
    /**
     * HTTP proxy excluded addresses
     */
    private Set<String> httpProxyExcludedAddresses;
    /**
     * HTTP proxy authentication URI
     */
    private String httpProxyAuthUri;
    /**
     * HTTP proxy authentication realm
     */
    private String httpProxyRealm;
    /**
     * Use HTTP proxy Digest authentication false by default
     */
    private Boolean httpProxyUseDigestAuth;
    /**
     * Package names to scan for DTO classes (multiple packages can be separated
     * by comma).
     */
    private String[] packages;
    /**
     * Salesforce login URL defaults to https://login.salesforce.com
     */
    private String loginUrl;
    /**
     * Salesforce connected application Consumer Key
     */
    private String clientId;
    /**
     * Salesforce connected application Consumer Secret
     */
    private String clientSecret;
    /**
     * Salesforce account user name
     */
    private String userName;
    /**
     * Salesforce account password
     */
    private String password;
    /**
     * Flag to enable/disable lazy OAuth default is false. When enabled OAuth
     * token retrieval or generation is not done until the first API call
     */
    private Boolean lazyLogin;
    /**
     * Payload format to use for Salesforce API calls either JSON or XML
     * defaults to JSON
     */
    private PayloadFormat format;
    /**
     * Salesforce API version defaults to
     * SalesforceEndpointConfig.DEFAULT_VERSION
     */
    private String apiVersion;
    /**
     * SObject name if required or supported by API
     */
    private String sObjectName;
    /**
     * SObject ID if required by API
     */
    private String sObjectId;
    /**
     * SObject fields to retrieve
     */
    private String sObjectFields;
    /**
     * SObject external ID field name
     */
    private String sObjectIdName;
    /**
     * SObject external ID field value
     */
    private String sObjectIdValue;
    /**
     * SObject blob field name
     */
    private String sObjectBlobFieldName;
    /**
     * Fully qualified SObject class name usually generated using
     * camel-salesforce-maven-plugin
     */
    private String sObjectClass;
    /**
     * Salesforce SOQL query string
     */
    private String sObjectQuery;
    /**
     * Salesforce SOSL search string
     */
    private String sObjectSearch;
    /**
     * APEX method name
     */
    private String apexMethod;
    /**
     * APEX method URL
     */
    private String apexUrl;
    /**
     * Query params for APEX method
     */
    private Map<String, Object> apexQueryParams;
    /**
     * Bulk API content type one of XML CSV ZIP_XML ZIP_CSV
     */
    private ContentType contentType;
    /**
     * Bulk API Job ID
     */
    private String jobId;
    /**
     * Bulk API Batch ID
     */
    private String batchId;
    /**
     * Bulk API Result ID
     */
    private String resultId;
    /**
     * Whether to update an existing Push Topic when using the Streaming API
     * defaults to false
     */
    private Boolean updateTopic;
    /**
     * Notify for fields options are ALL REFERENCED SELECT WHERE
     */
    private NotifyForFieldsEnum notifyForFields;
    /**
     * Notify for operations options are ALL CREATE EXTENDED UPDATE (API version
     * 29.0)
     */
    private NotifyForOperationsEnum notifyForOperations;
    /**
     * Notify for create operation defaults to false (API version = 29.0)
     */
    private Boolean notifyForOperationCreate;
    /**
     * Notify for update operation defaults to false (API version = 29.0)
     */
    private Boolean notifyForOperationUpdate;
    /**
     * Notify for delete operation defaults to false (API version = 29.0)
     */
    private Boolean notifyForOperationDelete;
    /**
     * Notify for un-delete operation defaults to false (API version = 29.0)
     */
    private Boolean notifyForOperationUndelete;
    /**
     * Salesforce1 Analytics report Id
     */
    private String reportId;
    /**
     * Include details in Salesforce1 Analytics report defaults to false.
     */
    private Boolean includeDetails;
    /**
     * Salesforce1 Analytics report metadata for filtering
     */
    private ReportMetadata reportMetadata;
    /**
     * Salesforce1 Analytics report execution instance ID
     */
    private String instanceId;
    /**
     * Custom Jetty Http Client to use to connect to Salesforce.
     */
    private SalesforceHttpClient httpClient;
    /**
     * Custom Jackson ObjectMapper to use when serializing/deserializing
     * Salesforce objects.
     */
    private ObjectMapper objectMapper;
    /**
     * Default replayId setting if no value is found in link initialReplayIdMap
     */
    private Integer defaultReplayId;
    /**
     * Replay IDs to start from per channel name.
     */
    private Map<String, Integer> initialReplayIdMap;

    public SalesforceLoginConfig getLoginConfig() {
        return loginConfig;
    }

    public void setLoginConfig(SalesforceLoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public SalesforceEndpointConfig getConfig() {
        return config;
    }

    public void setConfig(SalesforceEndpointConfig config) {
        this.config = config;
    }

    public Map<String, Object> getHttpClientProperties() {
        return httpClientProperties;
    }

    public void setHttpClientProperties(Map<String, Object> httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public SSLContextParameters getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(
            SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getHttpProxyHost() {
        return httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public Boolean getIsHttpProxySocks4() {
        return isHttpProxySocks4;
    }

    public void setIsHttpProxySocks4(Boolean isHttpProxySocks4) {
        this.isHttpProxySocks4 = isHttpProxySocks4;
    }

    public Boolean getIsHttpProxySecure() {
        return isHttpProxySecure;
    }

    public void setIsHttpProxySecure(Boolean isHttpProxySecure) {
        this.isHttpProxySecure = isHttpProxySecure;
    }

    public Set<String> getHttpProxyIncludedAddresses() {
        return httpProxyIncludedAddresses;
    }

    public void setHttpProxyIncludedAddresses(
            Set<String> httpProxyIncludedAddresses) {
        this.httpProxyIncludedAddresses = httpProxyIncludedAddresses;
    }

    public Set<String> getHttpProxyExcludedAddresses() {
        return httpProxyExcludedAddresses;
    }

    public void setHttpProxyExcludedAddresses(
            Set<String> httpProxyExcludedAddresses) {
        this.httpProxyExcludedAddresses = httpProxyExcludedAddresses;
    }

    public String getHttpProxyAuthUri() {
        return httpProxyAuthUri;
    }

    public void setHttpProxyAuthUri(String httpProxyAuthUri) {
        this.httpProxyAuthUri = httpProxyAuthUri;
    }

    public String getHttpProxyRealm() {
        return httpProxyRealm;
    }

    public void setHttpProxyRealm(String httpProxyRealm) {
        this.httpProxyRealm = httpProxyRealm;
    }

    public Boolean getHttpProxyUseDigestAuth() {
        return httpProxyUseDigestAuth;
    }

    public void setHttpProxyUseDigestAuth(Boolean httpProxyUseDigestAuth) {
        this.httpProxyUseDigestAuth = httpProxyUseDigestAuth;
    }

    public String[] getPackages() {
        return packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getLazyLogin() {
        return lazyLogin;
    }

    public void setLazyLogin(Boolean lazyLogin) {
        this.lazyLogin = lazyLogin;
    }

    public PayloadFormat getFormat() {
        return format;
    }

    public void setFormat(PayloadFormat format) {
        this.format = format;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getSObjectName() {
        return sObjectName;
    }

    public void setSObjectName(String sObjectName) {
        this.sObjectName = sObjectName;
    }

    public String getSObjectId() {
        return sObjectId;
    }

    public void setSObjectId(String sObjectId) {
        this.sObjectId = sObjectId;
    }

    public String getSObjectFields() {
        return sObjectFields;
    }

    public void setSObjectFields(String sObjectFields) {
        this.sObjectFields = sObjectFields;
    }

    public String getSObjectIdName() {
        return sObjectIdName;
    }

    public void setSObjectIdName(String sObjectIdName) {
        this.sObjectIdName = sObjectIdName;
    }

    public String getSObjectIdValue() {
        return sObjectIdValue;
    }

    public void setSObjectIdValue(String sObjectIdValue) {
        this.sObjectIdValue = sObjectIdValue;
    }

    public String getSObjectBlobFieldName() {
        return sObjectBlobFieldName;
    }

    public void setSObjectBlobFieldName(String sObjectBlobFieldName) {
        this.sObjectBlobFieldName = sObjectBlobFieldName;
    }

    public String getSObjectClass() {
        return sObjectClass;
    }

    public void setSObjectClass(String sObjectClass) {
        this.sObjectClass = sObjectClass;
    }

    public String getSObjectQuery() {
        return sObjectQuery;
    }

    public void setSObjectQuery(String sObjectQuery) {
        this.sObjectQuery = sObjectQuery;
    }

    public String getSObjectSearch() {
        return sObjectSearch;
    }

    public void setSObjectSearch(String sObjectSearch) {
        this.sObjectSearch = sObjectSearch;
    }

    public String getApexMethod() {
        return apexMethod;
    }

    public void setApexMethod(String apexMethod) {
        this.apexMethod = apexMethod;
    }

    public String getApexUrl() {
        return apexUrl;
    }

    public void setApexUrl(String apexUrl) {
        this.apexUrl = apexUrl;
    }

    public Map<String, Object> getApexQueryParams() {
        return apexQueryParams;
    }

    public void setApexQueryParams(Map<String, Object> apexQueryParams) {
        this.apexQueryParams = apexQueryParams;
    }

    public ContentType getContentType() {
        return contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getResultId() {
        return resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    public Boolean getUpdateTopic() {
        return updateTopic;
    }

    public void setUpdateTopic(Boolean updateTopic) {
        this.updateTopic = updateTopic;
    }

    public NotifyForFieldsEnum getNotifyForFields() {
        return notifyForFields;
    }

    public void setNotifyForFields(NotifyForFieldsEnum notifyForFields) {
        this.notifyForFields = notifyForFields;
    }

    public NotifyForOperationsEnum getNotifyForOperations() {
        return notifyForOperations;
    }

    public void setNotifyForOperations(
            NotifyForOperationsEnum notifyForOperations) {
        this.notifyForOperations = notifyForOperations;
    }

    public Boolean getNotifyForOperationCreate() {
        return notifyForOperationCreate;
    }

    public void setNotifyForOperationCreate(Boolean notifyForOperationCreate) {
        this.notifyForOperationCreate = notifyForOperationCreate;
    }

    public Boolean getNotifyForOperationUpdate() {
        return notifyForOperationUpdate;
    }

    public void setNotifyForOperationUpdate(Boolean notifyForOperationUpdate) {
        this.notifyForOperationUpdate = notifyForOperationUpdate;
    }

    public Boolean getNotifyForOperationDelete() {
        return notifyForOperationDelete;
    }

    public void setNotifyForOperationDelete(Boolean notifyForOperationDelete) {
        this.notifyForOperationDelete = notifyForOperationDelete;
    }

    public Boolean getNotifyForOperationUndelete() {
        return notifyForOperationUndelete;
    }

    public void setNotifyForOperationUndelete(Boolean notifyForOperationUndelete) {
        this.notifyForOperationUndelete = notifyForOperationUndelete;
    }

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Boolean getIncludeDetails() {
        return includeDetails;
    }

    public void setIncludeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
    }

    public ReportMetadata getReportMetadata() {
        return reportMetadata;
    }

    public void setReportMetadata(ReportMetadata reportMetadata) {
        this.reportMetadata = reportMetadata;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public SalesforceHttpClient getHttpClient() {
        return httpClient;
    }

    public void setHttpClient(SalesforceHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Integer getDefaultReplayId() {
        return defaultReplayId;
    }

    public void setDefaultReplayId(Integer defaultReplayId) {
        this.defaultReplayId = defaultReplayId;
    }

    public Map<String, Integer> getInitialReplayIdMap() {
        return initialReplayIdMap;
    }

    public void setInitialReplayIdMap(Map<String, Integer> initialReplayIdMap) {
        this.initialReplayIdMap = initialReplayIdMap;
    }
}