/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.ZonedDateTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeUtils;

public class DateTimeConverter
implements Converter {
    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        ZonedDateTime dateTime = (ZonedDateTime)o;
        writer.setValue(DateTimeUtils.formatDateTime(dateTime));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            return DateTimeUtils.parseDateTime(reader.getValue());
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Error reading ZonedDateTime from value %s: %s", reader.getValue(), e.getMessage()), (Throwable)e);
        }
    }

    public boolean canConvert(Class aClass) {
        return ZonedDateTime.class.isAssignableFrom(aClass);
    }
}

