/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.params.HttpClientParams;

public class ServletComponent
extends HttpComponent {
    private CamelServlet camelServlet;

    public void setCamelServlet(CamelServlet servlet) {
        this.camelServlet = servlet;
    }

    public CamelServlet getCamelServlet(String servletName) {
        CamelServlet answer = null;
        answer = this.camelServlet == null ? CamelHttpTransportServlet.getCamelServlet(servletName) : this.camelServlet;
        if (answer == null) {
            throw new IllegalArgumentException("Can't find the deployied servlet, please set the ServletComponent with it or delopy a CamelHttpTransportServlet int the web container");
        }
        return answer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        uri = uri.startsWith("servlet:") ? remaining : uri;
        HttpClientParams params = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)params, (Map)parameters, (String)"httpClient.");
        this.configureParameters(parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encode((String)uri)), (Map)parameters);
        uri = httpUri.toString();
        ServletEndpoint result = new ServletEndpoint(uri, this, httpUri, params, this.getHttpConnectionManager(), this.httpClientConfigurer);
        if (this.httpBinding != null) {
            result.setBinding(this.httpBinding);
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Object)result, parameters);
        return result;
    }

    public void connect(HttpConsumer consumer) throws Exception {
        ServletEndpoint endpoint = (ServletEndpoint)consumer.getEndpoint();
        CamelServlet servlet = this.getCamelServlet(endpoint.getServletName());
        ObjectHelper.notNull((Object)servlet, (String)"CamelServlet");
        servlet.connect(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        ServletEndpoint endpoint = (ServletEndpoint)consumer.getEndpoint();
        CamelServlet servlet = this.getCamelServlet(endpoint.getServletName());
        ObjectHelper.notNull((Object)servlet, (String)"CamelServlet");
        servlet.disconnect(consumer);
    }
}

