/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.DefaultHttpRegistry;
import org.apache.camel.component.servlet.HttpRegistry;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelHttpTransportServlet
extends CamelServlet {
    private static final long serialVersionUID = -1797014782158930490L;
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelHttpTransportServlet.class);
    @Resource
    private HttpRegistry httpRegistry;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.httpRegistry == null) {
            this.httpRegistry = DefaultHttpRegistry.getSingletonHttpRegistry();
        }
        this.httpRegistry.register(this);
        LOG.info("Initialized CamelHttpTransportServlet[{}]", (Object)this.getServletName());
    }

    public void destroy() {
        this.httpRegistry.unregister(this);
        LOG.info("Destroyed CamelHttpTransportServlet[{}]", (Object)this.getServletName());
    }

    private ServletEndpoint getServletEndpoint(HttpConsumer consumer) {
        if (!(consumer.getEndpoint() instanceof ServletEndpoint)) {
            throw new RuntimeException("Invalid consumer type. Must be ServletEndpoint but is " + consumer.getClass().getName());
        }
        return (ServletEndpoint)consumer.getEndpoint();
    }

    public void connect(HttpConsumer consumer) {
        ServletEndpoint endpoint = this.getServletEndpoint(consumer);
        if (endpoint.getServletName() != null && endpoint.getServletName().equals(this.getServletName())) {
            super.connect(consumer);
        }
    }
}

